#! /usr/bin/env python 
#name=Guess Number (Python)
#desc=Dialog example

import sys
import time
import math
import random
import planetcnc
import gcode

#sys.path.append(planetcnc.getPathProfile("Python"))
		
def Run():

	dlg = planetcnc.dlgNew("Guess Number", 1, 0, 0) #opt=1, w=0, h=0
	if (dlg == 0):
		print("Can not create dialog")
		return None
		
	planetcnc.dlgAddLabel(dlg, "Guess number between 1 and 10", 20, -1, 280, -1, 0xffa500) #x=20, w=280, color=0xffa500
	planetcnc.dlgAddImage(dlg, "./GuessNumber.png", 0, -1, -1, -1) #x=0
	planetcnc.dlgAddLabel(dlg, "Press OK to begin", 120, -1, 150, -1, 0xffa500) #x=120, w=150, color=0xffa500
	
	if (not planetcnc.dlgShow(dlg)):
		planetcnc.dlgClose(dlg)
		return None
	planetcnc.dlgClose(dlg)
	
	guess = random.randint(1,10)
	guess_my = 0
	
	for guess_cnt in range(10):
		dlg = planetcnc.dlgNew("Guess Number", 0, 0, 0) #opt=0, w=0, h=0
		if (dlg == 0):
			print("Can not create dialog")
			return None
		planetcnc.dlgAddLabel(dlg, "Guess number between 1 and 10", 20, -1, 280, -1, 0xffa500) #x=20, w=280, color=0xffa500
		planetcnc.dlgAddLabel(dlg, "Number of tries: " + str(guess_cnt+1), 20, -1, 280, -1, 0) #x=20, w=280, color=0
		planetcnc.dlgAddInput(dlg, "Number", guess_my, 1, 10, 0, 0, -1, -1, -1, 0) #val=guess_my, min=1, max=10, dec=0, x=0, color=0 
		planetcnc.dlgAddLabel(dlg, "Press OK to continue", 120, -1, 170, -1, 0xffa500) #x=120, w=170, color=0xffa500
		  
		if (not planetcnc.dlgShow(dlg)):
			planetcnc.dlgClose(dlg)
			break

		guess_my = planetcnc.dlgGetValue(dlg, 2)
		planetcnc.dlgClose(dlg)
		
		dlg = planetcnc.dlgNew("Guess Number", 1, 0, 0) #opt=1, w=0, h=0
		if (dlg == 0):
			print("Can not create dialog")
			return None
			
		if (guess_my > guess):
			planetcnc.dlgAddLabel(dlg, "Your number is too high", 20, -1, 280, -1, 0xffa500) #x=20, w=280, color=0xffa500
		elif (guess_my < guess):
			planetcnc.dlgAddLabel(dlg, "Your number is too low", 20, -1, 280, -1, 0xffa500) #x=20, w=280, color=0xffa500
		else:
			planetcnc.dlgAddLabel(dlg, "Congratulation!", 20, -1, 320, -1, 0xffa500) #x=20, w=320, color=0xffa500
			planetcnc.dlgAddLabel(dlg, "You guessed correct number in " + str(guess_cnt+1) + "tries", 20, -1, 320, -1, 0) #x=20, w=320, color=0

		planetcnc.dlgShow(dlg)
		planetcnc.dlgClose(dlg)
		
		if (guess_my == guess):
			break
	
if __name__ == '__main__':
	Run()

