import sys
import time
import datetime
import threading
import planetcnc


print("|!|bBEGIN", str(datetime.datetime.now()))

#Paths
print("getPath():                %s" %(planetcnc.getPath()))
print("getPathProfile():         %s" %(planetcnc.getPathProfile()))
print("getPathProfile('BlaBla'): %s" %(planetcnc.getPathProfile('BlaBla')))
print("getPathTemp():            %s" %(planetcnc.getPathTemp()))
print("getPathWorking():         %s" %(planetcnc.getPathWorking()))

#Run status
print("getVer():                 %d" %(planetcnc.getVer()))
print("isRunning():              %d" %(planetcnc.isRunning()))
print("isInitialized():          %d" %(planetcnc.isInitialized()))

#Version & Profile Info
print("getVersionString():       %s" %(planetcnc.getVersionString()))
print("getProfileNameString():   %s" %(planetcnc.getProfileNameString()))
print("getProfilePathString():   %s" %(planetcnc.getProfilePathString()))
print("getDescriptionString():   %s" %(planetcnc.getDescriptionString()))

#Screen
if (False):
	for i in range(4):
		isVisible = planetcnc.isVisible()
		print("IsVisible:", isVisible)
		if isVisible:
			planetcnc.hide()
		else:
			planetcnc.show()
			
		planetcnc.setProgress((i+1)/4)
		planetcnc.setStatus("Python counter " + str(i))
		time.sleep(5) # wait 5 second

	planetcnc.show() # make sure TNG is visible

planetcnc.setStatus("End of show/hide")
planetcnc.print("This is print to output window")
planetcnc.msg("This is message")

#Parameters & Eval
if (False):
	x = planetcnc.getParam("_hw_motor_x")
	y = planetcnc.getParam("_hw_motor_y")
	print("Motor position", "X:", x, "Y:", y)
	
	oldunits = planetcnc.getParam("_units")
	print("Units are set to", oldunits)
	
	if (oldunits == 20):
		newunits = 21
	else:
		newunits = 20
	
	planetcnc.setParam("_units", newunits)
	units = planetcnc.getParam("_units")
	print("Units are changed to", units)
	time.sleep(2)
	
	planetcnc.setParam("_units", oldunits)
	units = planetcnc.getParam("_units")
	print("Units are changed back to", units)
	time.sleep(2)
	
print("evaluate(2+3*4):          %s" %(planetcnc.evaluate("2+3*4")))
	
#State
print("isLicenseValid():         %d" %(planetcnc.isLicenseValid()))
print("isUIReady():              %d" %(planetcnc.isUIReady()))
print("isControllerReady():      %d" %(planetcnc.isControllerReady()))
print("isControllerRunning():    %d" %(planetcnc.isControllerRunning()))
print("isProgramLoaded():        %d" %(planetcnc.isProgramLoaded()))
print("isIdle():                 %d" %(planetcnc.isIdle()))
print("isEStop():                %d" %(planetcnc.isEStop()))
print("isStop():                 %d" %(planetcnc.isStop()))
print("isPause():                %d" %(planetcnc.isPause()))

#Machine Command status 
print("isEStopEnabled():         %d" %(planetcnc.isEStopEnabled()))
print("isStopEnabled():          %d" %(planetcnc.isStopEnabled()))
print("isPauseEnabled():         %d" %(planetcnc.isPauseEnabled()))
print("isStartEnabled():         %d" %(planetcnc.isStartEnabled()))
print("isOutputEnabled():        %d" %(planetcnc.isOutputEnabled()))
print("isCodeEnabled():          %d" %(planetcnc.isCodeEnabled()))
print("isCodeExEnabled():        %d" %(planetcnc.isCodeExEnabled()))
print("isOpenEnabled():          %d" %(planetcnc.isOpenEnabled()))
print("isCloseEnabled():         %d" %(planetcnc.isCloseEnabled()))

#Machine Commands
if (False):
	planetcnc.estopToggle()
	time.sleep(2)
	planetcnc.estopToggle()
	time.sleep(2)
	
	planetcnc.estop(False)
	
	
#Machine Commands Generic
openid = planetcnc.getCmdId("File.Open_File")
print("getCmdId(...):            %d" %(openid))
print("getCmdName(openid):       %s" %(planetcnc.getCmdName(openid)))
print("getCmdDisplayName(openid):%s" %(planetcnc.getCmdDisplayName(openid)))
print("isCmdEnabled(openid):     %d" %(planetcnc.isCmdEnabled(openid)))
print("isCmdChecked(openid):     %d" %(planetcnc.isCmdChecked(openid)))

if (False):
	ok = planetcnc.cmdExecStr(openid, "../../Samples/Mickey.nc")
	if (ok):
		print("File opened succesfully")
		while not planetcnc.isProgramLoaded():
			print("Waiting for program to load ...")
			time.sleep(0.5)
		print("Program loaded")
		planetcnc.start()
		time.sleep(5)
		planetcnc.pause(True)
		time.sleep(5)
		planetcnc.stop()
		time.sleep(1)
		planetcnc.close()

#Helpers		
#planetcnc.openFn("../../Samples/Mickey.nc")		
#planetcnc.openCode("%\nG00 X0 Y0\nG01 X20\nG01 Y20\nG01 X0\nG01 Y0\n%")	
		
#num = planetcnc.testFn("../../Samples/Mickey.nc")		
num = planetcnc.testCode("%\nG00 X0 Y0\nG01 X20\nGG01 Y20\nG01 X0\nG01 Y0\n%")
if num != 0:
	print("Error in line %d" %(num))
else:
	print("No errors")
	
#planetcnc.startFn("../../Samples/Mickey.nc")	
#planetcnc.startCode("%\nG00 X0 Y0\nG01 X20\nG01 Y20\nG01 X0\nG01 Y0\n%")


#planetcnc.cmd("File.Open_...")
#planetcnc.mdi("OPEN")
#planetcnc.cmd("File.Open_File|../../Samples/Mickey.nc")


#Info
print("infoIsInitialized():      %d" %(planetcnc.infoIsInitialized()))
print("infoSerial():             %d" %(planetcnc.infoSerial()))
print("infoHWVersion():          %d" %(planetcnc.infoHWVersion()))
print("infoSWVersion():          %d" %(planetcnc.infoSWVersion()))
print("infoIsVersionValid():     %d" %(planetcnc.infoIsVersionValid()))

print("infoWorkPos():            X:%f Y:%f Z:%f" %(planetcnc.infoWorkPos(0), planetcnc.infoWorkPos(1), planetcnc.infoWorkPos(2)))
print("infoMotorPos():           X:%f Y:%f Z:%f" %(planetcnc.infoMotorPos(0), planetcnc.infoMotorPos(1), planetcnc.infoMotorPos(2)))

print("infoSpeed():              %f" %(planetcnc.infoSpeed()))
print("infoAcceleration():       %f" %(planetcnc.infoAcceleration()))
print("infoSpindle():            %f" %(planetcnc.infoSpindle()))
print("infoSpindleIdx():         %f" %(planetcnc.infoSpindleIdx()))
print("infoSpindleEnc():         %f" %(planetcnc.infoSpindleEnc()))
print("infoSpindleSet():         %f" %(planetcnc.infoSpindleSet()))
print("infoInput():              %d" %(planetcnc.infoInput()))
print("infoJog():                %d" %(planetcnc.infoJog()))
print("infoJogPot():             %d" %(planetcnc.infoJogPot()))
print("infoLimit():              %d" %(planetcnc.infoLimit()))
print("infoOutput():             %d" %(planetcnc.infoOutput()))
print("infoOutputFreq(0):        %f" %(planetcnc.infoOutputFreq(0)))
print("infoOutputDuty(0):        %f" %(planetcnc.infoOutputFreq(0)))
print("infoOutputFreq(1):        %f" %(planetcnc.infoOutputFreq(1)))
print("infoOutputDuty(1):        %f" %(planetcnc.infoOutputFreq(1)))
print("infoOutputFreq(2):        %f" %(planetcnc.infoOutputFreq(2)))
print("infoOutputDuty(2):        %f" %(planetcnc.infoOutputFreq(2)))
print("infoAux(0):               %d" %(planetcnc.infoAux(0)))
print("infoAux(1):               %d" %(planetcnc.infoAux(1)))
print("infoAux(2):               %d" %(planetcnc.infoAux(2)))
print("infoAux(3):               %d" %(planetcnc.infoAux(3)))
print("infoBufferAvailable():    %d" %(planetcnc.infoBufferAvailable()))
print("infoBufferUtilization():  %f" %(planetcnc.infoBufferUtilization()))


print("|!|bEND")




























