import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())


	#Machine Commands Generic
	cnt = tng.API.GetCmdCount()
	print("GetCmdCount:", cnt)
	
	for id in range(cnt):
		namePtr = tng.API.GetCmdNameW(id)
		dispPtr = tng.API.GetCmdDisplayNameWithPathW(id)
		print(ctypes.wstring_at(namePtr), "=", ctypes.wstring_at(dispPtr))
		tng.API.FreeStringW(namePtr)
		tng.API.FreeStringW(dispPtr)
		

		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 09")





