import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())

	time.sleep(5)
	
	for i in range(15):
		x = ctypes.c_double()
		y = ctypes.c_double()
		z = ctypes.c_double()
		a = ctypes.c_double()
		b = ctypes.c_double()
		c = ctypes.c_double()
		u = ctypes.c_double()
		v = ctypes.c_double()
		w = ctypes.c_double()
		if (tng.API.InfoWorkPosition3(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z))):
			print("WorkPosition3", "X:", x.value, "Y:", y.value, "Z:", z.value)
		if (tng.API.InfoMotorPosition3(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z))):
			print("MotorPosition3", "X:", x.value, "Y:", y.value, "Z:", z.value)
			
		if (tng.API.InfoWorkUnitsPosition3(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z))):
			print("WorkUnitsPosition3", "X:", x.value, "Y:", y.value, "Z:", z.value)
		if (tng.API.InfoMotorUnitsPosition3(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z))):
			print("MotorUnitsPosition3", "X:", x.value, "Y:", y.value, "Z:", z.value)
			
		if (tng.API.InfoWorkPosition9(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z), ctypes.byref(a), ctypes.byref(b), ctypes.byref(c), ctypes.byref(u), ctypes.byref(v), ctypes.byref(w))):
			print("WorkPosition9", "X:", x.value, "Y:", y.value, "Z:", z.value, "A:", a.value, "B:", b.value, "C:", c.value, "U:", u.value, "V:", v.value, "W:", w.value)
		if (tng.API.InfoMotorPosition9(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z), ctypes.byref(a), ctypes.byref(b), ctypes.byref(c), ctypes.byref(u), ctypes.byref(v), ctypes.byref(w))):
			print("MotorPosition9", "X:", x.value, "Y:", y.value, "Z:", z.value, "A:", a.value, "B:", b.value, "C:", c.value, "U:", u.value, "V:", v.value, "W:", w.value)
			
		if (tng.API.InfoWorkUnitsPosition9(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z), ctypes.byref(a), ctypes.byref(b), ctypes.byref(c), ctypes.byref(u), ctypes.byref(v), ctypes.byref(w))):
			print("WorkUnitsPosition9", "X:", x.value, "Y:", y.value, "Z:", z.value, "A:", a.value, "B:", b.value, "C:", c.value, "U:", u.value, "V:", v.value, "W:", w.value)
		if (tng.API.InfoMotorUnitsPosition9(ctypes.byref(x), ctypes.byref(y), ctypes.byref(z), ctypes.byref(a), ctypes.byref(b), ctypes.byref(c), ctypes.byref(u), ctypes.byref(v), ctypes.byref(w))):
			print("MotorUnitsPosition9", "X:", x.value, "Y:", y.value, "Z:", z.value, "A:", a.value, "B:", b.value, "C:", c.value, "U:", u.value, "V:", v.value, "W:", w.value)
			
		time.sleep(1)


	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 08")





