import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())

	time.sleep(1)
	
	cmd = "File.Open_File"
	id = tng.API.GetCmdIdW(cmd)
	print("cmd:", cmd)
	print("GetCmdIdW:", id)
	print("IsCmdEnabled:", tng.API.IsCmdEnabled(id))
	print("IsCmdChecked:", tng.API.IsCmdChecked(id))
	
	namePtr = tng.API.GetCmdName(id)
	print("GetCmdName:", ctypes.string_at(namePtr).decode("utf-8"))
	tng.API.FreeString(namePtr)
	
	dispPtr = tng.API.GetCmdDisplayNameW(id)
	print("GetCmdDisplayName:", ctypes.wstring_at(dispPtr))
	tng.API.FreeStringW(dispPtr)
	
	time.sleep(15)
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 07")





