import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())

	time.sleep(5)
	
	for i in range(5):
		tng.API.EStop(True)
		time.sleep(1)
		tng.API.EStop(False)
		time.sleep(1)
		
	tng.API.StartFnW("../../Samples/Mickey.nc");
	time.sleep(5)
	
	for i in range(5):
		tng.API.PauseToggle()
		time.sleep(5)
		
	tng.API.Stop()
	time.sleep(5)
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 06")





