import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())

	time.sleep(4)
	
	for i in range(15):
		print("--------------------------------")
		print("IsEStopEnabled:", tng.API.IsEStopEnabled())
		print("IsStopEnabled:", tng.API.IsStopEnabled())
		print("IsPauseEnabled:", tng.API.IsPauseEnabled())
		print("IsStartEnabled:", tng.API.IsStartEnabled())
		print("IsOutputEnabled:", tng.API.IsOutputEnabled())
		print("IsCodeEnabled:", tng.API.IsCodeEnabled())
		print("IsCodeExEnabled:", tng.API.IsCodeExEnabled())
		print("IsOpenEnabled:", tng.API.IsOpenEnabled())
		print("IsCloseEnabled:", tng.API.IsCloseEnabled())
	
		time.sleep(1)
	
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 05")





