import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())

	time.sleep(4)
	
	for i in range(15):
		print("--------------------------------")
		print("IsLicenseValid:", tng.API.IsLicenseValid())
		print("IsUIReady:", tng.API.IsUIReady())
		print("IsControllerReady:", tng.API.IsControllerReady())
		print("IsControllerRunning:", tng.API.IsControllerRunning())
		print("IsProgramLoaded:", tng.API.IsProgramLoaded())
		
		print("IsIdle:", tng.API.IsIdle())
		print("IsEStop:", tng.API.IsEStop())
		print("IsStop:", tng.API.IsStop())
		print("IsPause:", tng.API.IsPause())
	
		time.sleep(1)
	
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 3 seconds
		time.sleep(3)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 04")





