import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Parameters & Eval
	x = tng.API.GetParamW("_hw_motor_x")
	y = tng.API.GetParamW("_hw_motor_y")
	print("Motor position", "X:", x, "Y:", y)
	
	oldunits = tng.API.GetParamW("_units")
	print("Units are set to", oldunits)
	
	if (oldunits == 20):
		newunits = 21
	else:
		newunits = 20
	
	tng.API.SetParamW("_units", newunits)
	units = tng.API.GetParamW("_units")
	print("Units are changed to", units)
	time.sleep(1)
	
	tng.API.SetParamW("_units", oldunits)
	units = tng.API.GetParamW("_units")
	print("Units are changed back to", units)
	time.sleep(1)
	
	
	expr = "2+3*4"
	res = tng.API.EvaluateW(expr)
	print(expr, "=", res)
	
	expr = "dist = sqrt(_hw_motor_x^2 + _hw_motor_y^2)"
	res = tng.API.EvaluateW(expr)
	print("Distance to zero is:", res)
	
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 10 seconds
		time.sleep(10)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 03")





