import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("Starting new TNG process")
		tng.Run()
		
	time.sleep(5) # wait 5 second
	
	# Screen
	for i in range(6):
		isVisible = tng.API.IsVisible()
		print("IsVisible:", isVisible)
		if isVisible:
			tng.API.Hide()
		else:
			tng.API.Show()
			
		tng.API.SetProgress((i+1)/6)
		tng.API.SetStatusW("Python counter " + str(i))
			
		time.sleep(5) # wait 5 second
		
	tng.API.Show() # make sure TNG is visible
	tng.API.SetStatus(ctypes.c_char_p(bytes("End of show/hide example", 'utf-8')))
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 10 seconds
		time.sleep(10)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 02")





