import sys
import time
import ctypes

import tng

try:
	
	# Run
	if tng.API.IsRunning():
		print("Using existing TNG process")
	elif tng.API.IsRunningExt():
		print("Using existing external TNG process")
	else:
		print("starting new TNG process")
		tng.Run()
	
	# Run status
	print("GetVer:", tng.API.GetVer())
	print("IsRunning:", tng.API.IsRunning())
	print("IsRunningExt:", tng.API.IsRunningExt())
	print("IsInitialized:", tng.API.IsInitialized())
	
	# Version & Profile Info
	print("GetVersionString:", str(tng.API.GetVersionString()))
	print("GetVersionStringW:", tng.API.GetVersionStringW())
	print("GetProfileNameString:", str(tng.API.GetProfileNameString()))
	print("GetProfileNameStringW:", tng.API.GetProfileNameStringW())
	print("GetDescriptionString:", str(tng.API.GetDescriptionString()))
	print("GetDescriptionStringW:", tng.API.GetDescriptionStringW())
		
	# Exit
	if tng.API.IsRunning(): # if we started TNG then exit after 10 seconds
		time.sleep(10)
		tng.API.Exit()

except Exception as e:
  print("Exception: ", str(e))
  tng.API.ExitForce()
  
print("End of example 01")





