
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>



#define PIPENAME	TEXT("\\\\.\\pipe\\PlanetCNC")

HANDLE hPipe = INVALID_HANDLE_VALUE;

#define TIMEOUT_WR	100
#define TIMEOUT_RD	2500

struct OverlappedEvent
{
	OverlappedEvent()
	{
		memset(&over, 0, sizeof(over));
		over.hEvent = CreateEvent(0, TRUE, FALSE, 0);
	}

	~OverlappedEvent()
	{
		CloseHandle(over.hEvent);
	}
	OVERLAPPED over;
};


bool open()
{
	if (hPipe != INVALID_HANDLE_VALUE)
		return true;

	hPipe = CreateFile(PIPENAME, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (hPipe != INVALID_HANDLE_VALUE)
		return true;

	return false;
}

void close()
{
	if (hPipe != INVALID_HANDLE_VALUE)
	{
		CloseHandle(hPipe);
		hPipe = INVALID_HANDLE_VALUE;
	}
}


bool waitForIO(OverlappedEvent& over, int timeOutMilliseconds)
{
	HANDLE handles[] = { over.over.hEvent };
	DWORD waitResult = WaitForMultipleObjects(1, handles, FALSE, timeOutMilliseconds >= 0 ? timeOutMilliseconds : INFINITE);

	if (waitResult == WAIT_OBJECT_0)
		return true;

	CancelIo(hPipe);
	return false;
}

int read(void* destBuffer, const int maxBytesToRead, const int timeOutMilliseconds)
{
	if (open())
	{
		if (maxBytesToRead <= 0)
			return 0;

		OverlappedEvent over;
		unsigned long numRead;

		if (ReadFile(hPipe, destBuffer, (DWORD)maxBytesToRead, &numRead, &over.over))
			return (int)numRead;

		const DWORD lastError = GetLastError();

		if (lastError == ERROR_IO_PENDING)
		{
			if (!waitForIO(over, timeOutMilliseconds))
				return -1;

			if (GetOverlappedResult(hPipe, &over.over, &numRead, FALSE))
				return (int)numRead;
		}
	}
	return -1;
}

int write(const void* sourceBuffer, int numBytesToWrite, int timeOutMilliseconds)
{
	if (open())
	{
		if (numBytesToWrite <= 0)
			return 0;

		OverlappedEvent over;
		unsigned long numWritten;

		if (WriteFile(hPipe, sourceBuffer, (DWORD)numBytesToWrite, &numWritten, &over.over))
			return (int)numWritten;

		if (GetLastError() == ERROR_IO_PENDING)
		{
			if (!waitForIO(over, timeOutMilliseconds))
				return -1;

			if (GetOverlappedResult(hPipe, &over.over, &numWritten, FALSE))
				return (int)numWritten;
		}
	}
	return -1;
}



int main(int argc, char* argv[])
{
	char msg[1024];
	int msglen, lenwr, lenrd;

	printf("? for command list");
	printf("\n");
	do
	{
		printf("PlanetCNC: ");
		fgets(msg, 1024, stdin);
		msglen = strnlen(msg, 1024);

		if (msglen > 1)
		{
			if (msg[0] == '?')
			{
				printf("#Run & Exit\n");
				printf("exit					Exits program\n");
				printf("\n");

				printf("#Version & Profile Info\n");
				printf("version					Returns version info\n");
				printf("profname				Returns profile name\n");
				printf("profpath				Returns profile path\n");
				printf("description				Returns description from settings\n");
				printf("\n");

				printf("#Screen\n");
				printf("isvisible				Returns 1 is main window is visible\n");
				printf("show					Shows main window\n");
				printf("hide					Hides main window\n");
				printf("setprogress <value>			Sets progress bar value\n");
				printf("setstatus <text>			Sets status bar text\n");
				printf("print <text>				Shows message box\n");
				printf("msg <text>				Prints text to output window\n");
				printf("\n");

				printf("#Parameters & Eval\n");
				printf("param <name>=<value>			Sets parameter <name> to <value>\n");
				printf("param <name>				Returns parameter <name>\n");
				printf("evaluate <expr>				Evaluates expression <expr>\n");
				printf("\n");

				printf("#State\n");
				printf("islicensevalid				Returns 1 if license is valid\n");
				printf("isuiready				Returns 1 if UI in not busy\n");
				printf("iscontrollerready			Returns 1 if controller is connected and ready to use\n");
				printf("iscontrollerrunning			Returns 1 if controller is running\n");
				printf("isprogramloaded				Returns 1 if g - gode program is loaded\n");
				printf("\n");
				printf("isidle					Returns 1 if machine is idle\n");
				printf("isestop					Returns 1 if e-stop is active\n");
				printf("isstop					Returns 1 if stop is active\n");
				printf("ispause					Returns 1 if pause is active\n");
				printf("\n");

				printf("#Machine Command status\n");
				printf("isestopenabled				Returns 1 if e - stop command is enabled\n");
				printf("isstopenabled				Returns 1 if stop command is enabled\n");
				printf("ispauseenabled				Returns 1 if pause command is enabled\n");
				printf("isstartenabled				Returns 1 if start command is enabled\n");
				printf("isoutputenabled				Returns 1 if output command is enabled\n");
				printf("iscodeenabled				Returns 1 if script code commands is enabled\n");
				printf("iscodeexenabled				Returns 1 if script code commands is enabled\n");
				printf("isopenenabled				Returns 1 if open command is enabled\n");
				printf("iscloseenabled				Returns 1 if close command is enabled\n");
				printf("\n");

				printf("#Machine Commands\n");
				printf("estop					Toggles e-stop\n");
				printf("estop_enable				Enables e-stop\n");
				printf("estop_disable				Disables e-stop\n");
				printf("stop					Performs stop\n");
				printf("pause					Performs pause\n");
				printf("pause_enable				Enables pause\n");
				printf("pause_disable				Disables pause\n");
				printf("start					Performs start\n");
				printf("close					Closes opened g-code\n");
				printf("\n");

				printf("#Machine Commands Generic\n");
				printf("getcmdcount				Returns command count\n");
				printf("getcmdid <name>				Returns command id command name\n");
				printf("getcmdidmdi <mdi>			Returns command id from mdi shortcut\n");
				printf("iscmdenabled <id>			Returns 1 if command is enabled and can be executed\n");
				printf("iscmdchecked <id>			Returns 1 if command is currently active\n");
				printf("getcmdname <id>				Returns command name\n");
				printf("getcmddispname <id>			Returns command display name\n");
				printf("getcmddispnamepath <id>			Returns command display name with path\n");
				printf("cmdexec <id>				Executes command\n");
				printf("cmdexecstr <id>|<str>			Executes command with string argument\n");
				printf("cmdexecval <id>|<val>			Executes command with double argument\n");
				printf("cmdexecintval <id>|<num> <val>		Executes command with int and double argument\n");
				printf("\n");

				printf("#Helpers\n");
				printf("openfile <fn>				Opens g-code from file\n");
				printf("opencode <code>				Opens g-code from string\n");
				printf("testfile <fn>				Tests g-code from file\n");
				printf("testcode <code>				Tests g-code from text\n");
				printf("startfile <fn>				Starts g-code from file\n");
				printf("startcode <code>			Starts g-code from text\n");
				printf("\n");

				printf("#G-Code\n");
				printf("filename				Returns opened filename\n");
				printf("linecount				Returns line count\n");
				printf("line <row>				Returns line\n");
				printf("linenum					Returns current line number\n");
				printf("\n");

				printf("#Info\n");
				printf("isinitialized				Returns 1 if controller is initialized\n");
				printf("serial					Returns controller serial number\n");
				printf("hwversion				Returns controller version number\n");
				printf("swversion				Returns software version number\n");
				printf("versionvalid				Returns 1 if controller version is correct\n");
				printf("\n");
				printf("poswork					Returns position for all axes\n");
				printf("posworkx				Returns position for X axis\n");
				printf("posworky				Returns position for Y axis\n");
				printf("posworkz				Returns position for Z axis\n");
				printf("posworka				Returns position for A axis\n");
				printf("posworkb				Returns position for B axis\n");
				printf("posworkc				Returns position for C axis\n");
				printf("posworku				Returns position for U axis\n");
				printf("posworkv				Returns position for V axis\n");
				printf("posworkw				Returns position for W axis\n");
				printf("\n");
				printf("posmotor				Returns motor position for all axes\n");
				printf("posmotorx				Returns motor position for X axis\n");
				printf("posmotory				Returns motor position for Y axis\n");
				printf("posmotorz				Returns motor position for Z axis\n");
				printf("posmotora				Returns motor position for A axis\n");
				printf("posmotorb				Returns motor position for B axis\n");
				printf("posmotorc				Returns motor position for C axis\n");
				printf("posmotoru				Returns motor position for U axis\n");
				printf("posmotorv				Returns motor position for V axis\n");
				printf("posmotorw				Returns motor position for W axis\n");
				printf("\n");
				printf("speed					Returns current speed\n");
				printf("accel					Returns current acceleration\n");
				printf("spindle					Returns current spindle RPM\n");
				printf("spindle_idx				Returns current spindle RPM from index\n");
				printf("spindle_enc				Returns current spindle RPM from encoder\n");
				printf("spindle_set				Returns current spindle RPM as set in g - code\n");
				printf("\n");
				printf("inputhex				Returns value of INPUT in hex format\n");
				printf("input					Returns value of INPUT\n");
				printf("input1					Returns value of INPUT 1 pin\n");
				printf("input2					Returns value of INPUT 2 pin\n");
				printf("input3					Returns value of INPUT 3 pin\n");
				printf("input4					Returns value of INPUT 4 pin\n");
				printf("input5					Returns value of INPUT 5 pin\n");
				printf("input6					Returns value of INPUT 6 pin\n");
				printf("input7					Returns value of INPUT 7 pin\n");
				printf("input8					Returns value of INPUT 8 pin\n");
				printf("\n");
				printf("joghex					Returns value of JOG in hex format\n");
				printf("jog					Returns value of JOG\n");
				printf("jog1					Returns value of JOG 1 pin\n");
				printf("jog2					Returns value of JOG 2 pin\n");
				printf("jog3					Returns value of JOG 3 pin\n");
				printf("jog4					Returns value of JOG 4 pin\n");
				printf("jog5					Returns value of JOG 5 pin\n");
				printf("jog6					Returns value of JOG 6 pin\n");
				printf("jog7					Returns value of JOG 7 pin\n");
				printf("jog8					Returns value of JOG 8 pin\n");
				printf("joga1					Returns value of JOG A1 pin\n");
				printf("joga2					Returns value of JOG A2 pin\n");
				printf("jogs					Returns value of JOG S pin\n");
				printf("jogpot					Returns value of JOG POT\n");
				printf("\n");
				printf("limithex				Returns value of LIMIT in hex format\n");
				printf("limit					Returns value of LIMIT\n");
				printf("limit1					Returns value of LIMIT 1 pin\n");
				printf("limit2					Returns value of LIMIT 2 pin\n");
				printf("limit3					Returns value of LIMIT 3 pin\n");
				printf("limit4					Returns value of LIMIT 4 pin\n");
				printf("limit5					Returns value of LIMIT 5 pin\n");
				printf("limit6					Returns value of LIMIT 6 pin\n");
				printf("limit7					Returns value of LIMIT 7 pin\n");
				printf("limit8					Returns value of LIMIT 8 pin\n");
				printf("limit9					Returns value of LIMIT 9 pin\n");
				printf("\n");
				printf("outputhex				Returns value of OUTPUT in hex format\n");
				printf("output					Returns value of OUTPUT\n");
				printf("output1					Returns value of OUTPUT 1 pin\n");
				printf("output2					Returns value of OUTPUT 2 pin\n");
				printf("output3					Returns value of OUTPUT 3 pin\n");
				printf("output4					Returns value of OUTPUT 4 pin\n");
				printf("output5					Returns value of OUTPUT 5 pin\n");
				printf("output6					Returns value of OUTPUT 6 pin\n");
				printf("output7					Returns value of OUTPUT 7 pin\n");
				printf("output8					Returns value of OUTPUT 8 pin\n");
				printf("\n");
				printf("outputfreq1				Returns frequency of OUTPUT 1 pin\n");
				printf("outputduty1				Returns duty cycle of OUTPUT 1 pin\n");
				printf("outputfreq2				Returns frequency of OUTPUT 2 pin\n");
				printf("outputduty2				Returns duty cycle of OUTPUT 2 pin\n");
				printf("outputfreq3				Returns frequency of OUTPUT 6 pin\n");
				printf("outputduty3				Returns duty cycle of OUTPUT 6 pin\n");
				printf("\n");
				printf("aux1					Returns value of AUX 1 pin\n");
				printf("aux2					Returns value of AUX 2 pin\n");
				printf("aux3					Returns value of AUX 3 pin\n");
				printf("aux4					Returns value of AUX 4 pin\n");
				printf("\n");
				printf("buffer					Returns amount of free buffer\n");
				printf("bufferutil				Returns buffer utilization\n");

				printf("\n");
				continue;
			}

			read(msg, 1024, 1); // clear previous return value

			lenwr = write(msg, msglen, TIMEOUT_WR);
			if (lenwr > 0)
			{
				lenrd = read(msg, 1024, TIMEOUT_RD);
				if (lenrd > 0)
				{
					msg[lenrd] = 0;
					printf("%s\n", msg);
				}
				else
				{
					printf("NO RESPONSE\n");
				}
			}
			else
			{
				printf("NO CONNECTION\n");
			}
		}

	} while (msglen > 1);

	close();

	return 0;
}

