
#ifndef __PlanetCNCLib_H__
#define __PlanetCNCLib_H__


#include "PlanetCNCLibTypeDef.h"


#ifdef __cplusplus
extern "C" {
#endif

#ifndef PCNC_CALL
#	ifdef _WIN32
#		define PCNC_CALL __cdecl
#	else
#		define PCNC_CALL
#	endif
#endif

#ifndef PCNC_EXPORT
#	ifdef _WIN32
#		define PCNC_EXPORT __declspec(dllexport)
#	else
#		define PCNC_EXPORT __attribute__((visibility("default"))) 
#	endif
#endif


	//Memory
	PCNC_EXPORT void FreeString(char* str);
	PCNC_EXPORT void FreeStringW(wchar_t* strw);

	//Callback
	PCNC_EXPORT void SetInitialiseCB(__InitialiseCB cb);
	PCNC_EXPORT void SetRefreshCB(__RefreshCB cb);
	PCNC_EXPORT void SetOpenCB(__OpenCB cb);
	PCNC_EXPORT void SetOutputCB(__OutputCB cb);
	PCNC_EXPORT void SetOutputWCB(__OutputWCB cb);
	PCNC_EXPORT void SetIdleCB(__IdleCB cb);
	PCNC_EXPORT void SetLineNumCB(__LineNumCB cb);

	//Run & Exit
	PCNC_EXPORT int Run(bool hideUI);
	PCNC_EXPORT int RunProfile(bool hideUI, const char* profile);
	PCNC_EXPORT int RunProfileW(bool hideUI, const wchar_t* profile);
	PCNC_EXPORT void Exit(); //pipe: exit
	PCNC_EXPORT void ExitForce();

	//Run status
	PCNC_EXPORT int GetVer();
	PCNC_EXPORT char* GetLibPath();
	PCNC_EXPORT wchar_t* GetLibPathW();

	PCNC_EXPORT bool IsRunning();
	PCNC_EXPORT bool IsRunningExt();
	PCNC_EXPORT unsigned long long GetDateTime();
	PCNC_EXPORT bool IsInitialized();

	//Version & Profile Info
	PCNC_EXPORT const char* GetVersionString(); //pipe: version
	PCNC_EXPORT const wchar_t* GetVersionStringW();
	PCNC_EXPORT const char* GetProfileNameString(); //pipe:: profname
	PCNC_EXPORT const wchar_t* GetProfileNameStringW();
	PCNC_EXPORT const char* GetProfilePathString(); //pipe:: profpath
	PCNC_EXPORT const wchar_t* GetProfilePathStringW();
	PCNC_EXPORT const char* GetDescriptionString(); //pipe: description
	PCNC_EXPORT const wchar_t* GetDescriptionStringW();

	//Screen
	PCNC_EXPORT bool IsVisible(); //pipe: isvisible
	PCNC_EXPORT bool Show(); //pipe: show
	PCNC_EXPORT bool Hide(); //pipe: hide
	PCNC_EXPORT bool SetProgress(double dbl); //pipe: setprogress <value>
	PCNC_EXPORT bool SetStatus(const char* str); //pipe: setstatus <text>
	PCNC_EXPORT bool SetStatusW(const wchar_t* strw);
	PCNC_EXPORT bool Msg(const char* str); //pipe: msg <text>
	PCNC_EXPORT bool MsgW(const wchar_t* strw);
	PCNC_EXPORT bool Print(const char* str); //pipe: print <text>
	PCNC_EXPORT bool PrintW(const wchar_t* strw);

	//Parameters & Eval
	PCNC_EXPORT double GetParam(const char* param); //pipe: param <name>
	PCNC_EXPORT double GetParamW(const wchar_t* param);
	PCNC_EXPORT bool SetParam(const char* param, double value); //pipe: param <name>=<value>
	PCNC_EXPORT bool SetParamW(const wchar_t* param, double value);
	PCNC_EXPORT double Evaluate(const char* expr); //pipe: evaluate <expr>
	PCNC_EXPORT double EvaluateW(const wchar_t* expr);

	//State
	PCNC_EXPORT bool IsLicenseValid(); //pipe: islicensevalid
	PCNC_EXPORT bool IsUIReady(); //pipe: isuiready
	PCNC_EXPORT bool IsControllerReady(); //pipe: iscontrollerready
	PCNC_EXPORT bool IsControllerRunning(); //pipe: iscontrollerrunning
	PCNC_EXPORT bool IsProgramLoaded(); //pipe: isprogramloaded

	PCNC_EXPORT bool IsIdle(); //pipe: isidle
	PCNC_EXPORT bool IsEStop(); //pipe: isestop
	PCNC_EXPORT bool IsStop(); //pipe: isstop
	PCNC_EXPORT bool IsPause(); //pipe: ispause
	PCNC_EXPORT bool IsProg(); //pipe: isprog
	PCNC_EXPORT bool IsCmd(); //pipe: iscmd
	PCNC_EXPORT bool IsJog(); //pipe: isjog

	//Machine Command Status
	PCNC_EXPORT bool IsEStopEnabled(); //pipe: isestopenabled
	PCNC_EXPORT bool IsStopEnabled(); //pipe: isstopenabled
	PCNC_EXPORT bool IsPauseEnabled(); //pipe: ispauseenabled
	PCNC_EXPORT bool IsStartEnabled(); //pipe: isstartenabled
	PCNC_EXPORT bool IsOutputEnabled(); //pipe: isoutputenabled
	PCNC_EXPORT bool IsCodeEnabled(); //for most scripts //pipe: iscodeenabled
	PCNC_EXPORT bool IsCodeExEnabled(); //for homing and toolchange //pipe: iscodeexenabled
	PCNC_EXPORT bool IsOpenEnabled(); //pipe: isopenenabled
	PCNC_EXPORT bool IsCloseEnabled(); //pipe: iscloseenabled

	//Machine Commands
	PCNC_EXPORT bool EStop(bool b); //pipe: estop_enable/estop_disable
	PCNC_EXPORT bool EStopToggle(); //pipe: estop
	PCNC_EXPORT bool Stop(); //pipe: stop
	PCNC_EXPORT bool Pause(bool b); //pipe: pause_enable/pause_disable
	PCNC_EXPORT bool PauseToggle(); //pipe: pause
	PCNC_EXPORT bool Start(); //pipe: start
	PCNC_EXPORT bool Open(); //pipe: open
	PCNC_EXPORT bool Close(); //pipe: close


	//Machine Commands Generic
	PCNC_EXPORT int GetCmdCount(); //pipe: getcmdcount
	PCNC_EXPORT int GetCmdId(const char* str); //pipe: getcmdid
	PCNC_EXPORT int GetCmdIdW(const wchar_t* strw); 
	PCNC_EXPORT int GetCmdIdFromMdi(const char* str); //pipe: getcmdidmdi
	PCNC_EXPORT int GetCmdIdFromMdiW(const wchar_t* strw); 

	PCNC_EXPORT bool IsCmdEnabled(int id); //pipe: iscmdenabled
	PCNC_EXPORT bool IsCmdChecked(int id); //pipe: iscmdchecked

	PCNC_EXPORT char* GetCmdName(int id); //pipe: getcmdname
	PCNC_EXPORT wchar_t* GetCmdNameW(int id); 
	PCNC_EXPORT char* GetCmdDisplayName(int id); //pipe: getcmddispname
	PCNC_EXPORT wchar_t* GetCmdDisplayNameW(int id); 
	PCNC_EXPORT char* GetCmdDisplayNameWithPath(int id); //pipe: getcmddispnamepath
	PCNC_EXPORT wchar_t* GetCmdDisplayNameWithPathW(int id);

	PCNC_EXPORT bool CmdExec(int id); //pipe: cmdexec

	PCNC_EXPORT bool CmdExecStr(int id, const char* str); //pipe: cmdexecstr
	PCNC_EXPORT bool CmdExecStrW(int id, const wchar_t* strw); 
	PCNC_EXPORT bool CmdExecVal(int id, double val); //pipe: cmdexecval
	PCNC_EXPORT bool CmdExecIntVal(int id, int num, double val); //pipe: cmdexecintval

	//Helpers
	PCNC_EXPORT bool OpenFn(const char* str); //pipe: openfile
	PCNC_EXPORT bool OpenFnW(const wchar_t* strw);
	PCNC_EXPORT bool OpenCode(const char* str); //pipe: opencode
	PCNC_EXPORT bool OpenCodeW(const wchar_t* strw);
	
	PCNC_EXPORT int TestFn(const char* str); //pipe: testfile
	PCNC_EXPORT int TestFnW(const wchar_t* strw);
	PCNC_EXPORT int TestCode(const char* str); //pipe: testcode
	PCNC_EXPORT int TestCodeW(const wchar_t* strw);

	PCNC_EXPORT bool StartFn(const char* str); //pipe: startfile
	PCNC_EXPORT bool StartFnW(const wchar_t* strw);
	PCNC_EXPORT bool StartCode(const char* str); //pipe: startcode
	PCNC_EXPORT bool StartCodeW(const wchar_t* strw);
	
	//G-Code
	PCNC_EXPORT char* GetFn(); //pipe: filename (NO EXT)
	PCNC_EXPORT wchar_t* GetFnW();
	PCNC_EXPORT	int GetLineCount(); //pipe: linecount
	PCNC_EXPORT	char* GetLine(int row); //pipe: line <row> (NO EXT)
	PCNC_EXPORT	wchar_t* GetLineW(int row);
	PCNC_EXPORT	int GetLineNum(); //pipe: linenum

	//Info
	PCNC_EXPORT	bool InfoIsInitialized(); //pipe: isinitialized
	PCNC_EXPORT	int InfoSerial(); //pipe: serial
	PCNC_EXPORT	int InfoHWVersion(); //pipe: hwversion
	PCNC_EXPORT	int InfoSWVersion(); //pipe: swversion
	PCNC_EXPORT	bool InfoIsVersionValid(); //pipe: versionvalid

	PCNC_EXPORT double InfoWorkPosition(int n); //pipe: poswork<axis>
	PCNC_EXPORT bool InfoWorkPosition3(double* x, double* y, double* z);
	PCNC_EXPORT bool InfoWorkPosition9(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w); //pipe: poswork

	PCNC_EXPORT double InfoMotorPosition(int n);//pipe: posmotor<axis>
	PCNC_EXPORT bool InfoMotorPosition3(double* x, double* y, double* z);
	PCNC_EXPORT bool InfoMotorPosition9(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);//pipe: posmotor

	PCNC_EXPORT double InfoWorkUnitsPosition(int n); //pipe: posworkunits<axis>
	PCNC_EXPORT bool InfoWorkUnitsPosition3(double* x, double* y, double* z);
	PCNC_EXPORT bool InfoWorkUnitsPosition9(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w); //pipe: posworkunits

	PCNC_EXPORT double InfoMotorUnitsPosition(int n);//pipe: posmotorunits<axis>
	PCNC_EXPORT bool InfoMotorUnitsPosition3(double* x, double* y, double* z);
	PCNC_EXPORT bool InfoMotorUnitsPosition9(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);//pipe: posmotorunits

	PCNC_EXPORT double InfoSpeed(); //pipe: speed
	PCNC_EXPORT double InfoAcceleration(); //pipe: accel
	PCNC_EXPORT double InfoSpindle(); //pipe: spindle
	PCNC_EXPORT double InfoSpindleIdx(); //pipe: spindle_idx
	PCNC_EXPORT double InfoSpindleEnc(); //pipe: spindle_enc
	PCNC_EXPORT double InfoSpindleSet(); //pipe: spindle_set

	PCNC_EXPORT bool InfoSpeedOverrideEnabled(); //pipe: speed_ovrden
	PCNC_EXPORT bool InfoSpindleOverrideEnabled(); //pipe: spindle_ovrden

	PCNC_EXPORT unsigned int InfoInput(); //pipe: input
	PCNC_EXPORT unsigned int InfoJog(); //pipe: jog
	PCNC_EXPORT unsigned int InfoJogPot(); //pipe: jogpot
	PCNC_EXPORT unsigned int InfoLimit(); //pipe: limit
	PCNC_EXPORT unsigned int InfoOutput(); //pipe: output
	PCNC_EXPORT double InfoOutputFreq(int num); //pipe: outputfreq<num>
	PCNC_EXPORT double InfoOutputDuty(int num); //pipe: outputduty<num>
	PCNC_EXPORT unsigned int InfoAux(int num); //pipe: aux<num>

	PCNC_EXPORT unsigned int InfoBufferAvailable(); //pipe: buffer
	PCNC_EXPORT double InfoBufferUtilization(); //pipe: bufferutil

	//Direct Commands
	PCNC_EXPORT bool MoveAxis(double speed, int axis, double val);
	PCNC_EXPORT bool Move3(double speed, double x, double y, double z);
	PCNC_EXPORT bool Move9(double speed, double x, double y, double z, double a, double b, double c, double u, double v, double w);

	PCNC_EXPORT bool Output(int num, bool value);
	PCNC_EXPORT bool OutputPWM(int num, int freq, double duty);
	PCNC_EXPORT bool OutputRC(int num, double value);

	PCNC_EXPORT bool I2C(int addr, const unsigned char* data, int len);
	PCNC_EXPORT bool I2Cret(int addr, const unsigned char* data, int len, unsigned char* dataret, int lenret);

	PCNC_EXPORT bool ExtOut(int ssel, unsigned int value, int total);
	PCNC_EXPORT bool ExtOutPin(int ssel, int pin, bool state, int total);

	//Jog
	PCNC_EXPORT bool JogStop();
	PCNC_EXPORT bool Jog(bool step, double x, double y, double z);
	PCNC_EXPORT bool Jog9(bool step, double x, double y, double z, double a, double b, double c, double u, double v, double w);

	//THC
	PCNC_EXPORT bool THC(bool arcok, int dir);

	//G-Code Lines
	PCNC_EXPORT void* LineListCreate();
	PCNC_EXPORT void LineListFree(void* ptr);

	PCNC_EXPORT bool LineListClear(void* ptr);
	PCNC_EXPORT int LineListCount(void* ptr);

	PCNC_EXPORT bool LineListAddAllowed(void* ptr);
	PCNC_EXPORT bool LineListAdd(void* ptr, const char* str);
	PCNC_EXPORT bool LineListAddW(void* ptr, const wchar_t* str);

	PCNC_EXPORT	char* LineListGet(void* ptr, int i);
	PCNC_EXPORT	wchar_t* LineListGetW(void* ptr, int i);

	PCNC_EXPORT bool LineListLoadFromFile(void* ptr, const char* fn);
	PCNC_EXPORT bool LineListLoadFromFileW(void* ptr, const wchar_t* fn);

	PCNC_EXPORT bool OpenLineList(void* ptr);
	PCNC_EXPORT int TestLineList(void* ptr);
	PCNC_EXPORT bool StartLineList(void* ptr);



#ifdef __cplusplus
}
#endif

#endif 

