﻿using System;
using System.Runtime.InteropServices;

public class TNG
{
#if WIN64
    private const string PlanetCNCLib = "PlanetCNCLib64.dll";
#else
    private const string PlanetCNCLib = "PlanetCNCLib32.dll";
#endif

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern void FreeString(IntPtr str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern void FreeStringW(IntPtr strw);

    //Callbacks
    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __InitialiseCB(Int32 i);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetInitialiseCB(__InitialiseCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __RefreshCB();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetRefreshCB(__RefreshCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __OpenCB(Int32 i);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetOpenCB(__OpenCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __OutputCB(IntPtr s);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetOutputCB(__OutputCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __OutputWCB(IntPtr s);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetOutputWCB(__OutputWCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __IdleCB();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetIdleCB(__IdleCB lpfn);

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate void __LineNumCB(Int32 i);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void SetLineNumCB(__LineNumCB lpfn);




    //Run & Exit
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 Run([MarshalAs(UnmanagedType.U1)]bool hideUI);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern Int32 RunProfile([MarshalAs(UnmanagedType.U1)]bool hideUI, string profile);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern Int32 RunProfileW([MarshalAs(UnmanagedType.U1)]bool hideUI, string profile);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void Exit();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void ExitForce();


    //Run status
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 GetVer();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetLibPath();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetLibPathW();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsRunning();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsRunningExt();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsInitialized();


    //Version & Profile Info
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetVersionString();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetVersionStringW();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetProfileNameString();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetProfileNameStringW();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetProfilePathString();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetProfilePathStringW();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetDescriptionString();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetDescriptionStringW();


    //Screen
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsVisible();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Show();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Hide();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SetProgress(double prog);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SetStatus(string stat);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SetStatusW(string stat);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Print(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool PrintW(string strw);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Msg(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool MsgW(string strw);


    //Parameters & Eval
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern double GetParam(string param);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern double GetParamW(string param);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SetParam(string param, double val);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SetParamW(string param, double val);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern double Evaluate(string expr);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern double EvaluateW(string expr);


    //State
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsLicenseValid();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsUIReady();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsControllerReady();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsControllerRunning();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsProgramLoaded();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsIdle();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsEStop();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsStop();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsPause();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsMDI();

    //Machine Command status
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsEStopEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsStopEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsPauseEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsStartEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsOutputEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsCodeEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsCodeExEnabled();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsOpenEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsCloseEnabled();


    //Machine Commands
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool EStop([MarshalAs(UnmanagedType.U1)]bool b);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool EStopToggle();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Stop();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Pause([MarshalAs(UnmanagedType.U1)]bool b);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool PauseToggle();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Start();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Open();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Close();


    //Machine Commands Generic
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern Int32 GetCmdCount();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern Int32 GetCmdId(string cmd);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern Int32 GetCmdIdW(string cmd);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern Int32 GetCmdIdFromMdi(string cmd);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern Int32 GetCmdIdFromMdiW(string cmd);


    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsCmdEnabled(Int32 id);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool IsCmdChecked(Int32 id);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetCmdName(Int32 id);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetCmdNameW(Int32 id);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetCmdDisplayName(Int32 id);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetCmdDisplayNameW(Int32 id);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetCmdDisplayNameWithPath(Int32 id);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetCmdDisplayNameWithPathW(Int32 id);


    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool CmdExec(Int32 id);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool CmdExecStr(Int32 id, string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool CmdExecStrW(Int32 id, string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool CmdExecVal(Int32 id, double val);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool CmdExecIntVal(Int32 id, Int32 num, double val);

    //Helpers
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OpenFn(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OpenFnW(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OpenCode(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OpenCodeW(string str);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int TestFn(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern int TestFnW(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern int TestCode(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern int TestCodeW(string str);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool StartFn(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool StartFnW(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool StartCode(string str);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool StartCodeW(string str);


    //G-Code
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetFn();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetFnW();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 GetLineCount();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr GetLine(Int32 row);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr GetLineW(Int32 row);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 GetLineNum();



    //Info
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoIsInitialized();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 InfoSerial();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 InfoHWVersion();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern Int32 InfoSWVersion();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoIsVersionValid();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoWorkPosition(Int32 axis);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoWorkPosition3(out double x, out double y, out double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoWorkPosition9(out double x, out double y, out double z, out double a, out double b, out double c, out double u, out double v, out double w);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoMotorPosition(UInt32 axis);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoMotorPosition3(out double x, out double y, out double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoMotorPosition9(out double x, out double y, out double z, out double a, out double b, out double c, out double u, out double v, out double w);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoWorkUnitsPosition(Int32 axis);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoWorkUnitsPosition3(out double x, out double y, out double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoWorkUnitsPosition9(out double x, out double y, out double z, out double a, out double b, out double c, out double u, out double v, out double w);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoMotorUnitsPosition(UInt32 axis);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoMotorUnitsPosition3(out double x, out double y, out double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoMotorUnitsPosition9(out double x, out double y, out double z, out double a, out double b, out double c, out double u, out double v, out double w);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoSpeed();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoAcceleration();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoSpindle();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoSpindleIdx();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoSpindleEnc();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoSpindleSet();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoSpeedOverrideEnabled();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool InfoSpindleOverrideEnabled();

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoInput();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoJog();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoJogPot();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoLimit();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoOutput();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoOutputFreq(Int32 num);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoOutputDuty(Int32 num);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoAux(Int32 num);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern UInt32 InfoBufferAvailable();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern double InfoBufferUtilization();


    //Direct Commands
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool MoveAxis(double speed, int axis, double val);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Move3(double speed, double x, double y, double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Move9(double speed, double x, double y, double z, double a, double b, double c, double u, double v, double w);


    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Output(int num, [MarshalAs(UnmanagedType.U1)]bool value);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OutputPWM(int num, int freq, double duty);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OutputRC(int num, double value);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool I2C(int addr, byte[] data, int len);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool I2Cret(int addr, byte[] data, int len, [In, Out]byte[] dataret, int lenret);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SPI(int ssel, uint value, int total);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool SPIpin(int ssel, int pin, [MarshalAs(UnmanagedType.U1)]bool state, int total);


    //Jog
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool JogStop();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Jog([MarshalAs(UnmanagedType.U1)]bool step, double x, double y, double z);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool Jog9([MarshalAs(UnmanagedType.U1)]bool step, double x, double y, double z, double a, double b, double c, double u, double v, double w);


    //THC
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool THC(bool arcok, int dir);


    //LineList
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern IntPtr LineListCreate();
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern void LineListFree(IntPtr ptr);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListClear(IntPtr ptr);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern int LineListCount(IntPtr ptr);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListAddAllowed(IntPtr ptr);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListAdd(IntPtr ptr, string line);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListAddW(IntPtr ptr, string line);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    public static extern IntPtr LineListGet(IntPtr ptr, int i);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    public static extern IntPtr LineListGetW(IntPtr ptr, int i);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListLoadFromFile(IntPtr ptr, string fn);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool LineListLoadFromFileW(IntPtr ptr, string fn);

    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool OpenLineList(IntPtr ptr);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    public static extern int TestLineList(IntPtr ptr);
    [DllImport(PlanetCNCLib, CallingConvention = CallingConvention.Cdecl)]
    [return: MarshalAs(UnmanagedType.U1)]
    public static extern bool StartLineList(IntPtr ptr);

}



