﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;
using System.Threading;
using System.Globalization;

using System.IO;
using System.IO.Pipes;

namespace Demo
{
    public partial class MainForm : Form
    {
        volatile bool _Init;
        volatile bool _InitExt;
        public MainForm()
        {
            InitialiseCBRef = new TNG.__InitialiseCB(InitialiseCB);
            RefreshCBRef = new TNG.__RefreshCB(RefreshCB);
            OpenCBRef = new TNG.__OpenCB(OpenCB);
            OutputCBRef = new TNG.__OutputCB(OutputCB);
            //OutputWCBRef = new TNG.__OutputWCB(OutputWCB);
            IdleCBRef = new TNG.__IdleCB(IdleCB);
            LineNumCBRef = new TNG.__LineNumCB(LineNumCB);

            InitializeComponent();
            _InitExt = TNG.IsRunningExt();
            /*
            if (_InitExt)
            {
                InitializeCommands();
                //TODO: start update timer
            }
            else
            */
            DisableCommands();

        }

        ~MainForm()
        {
            InitialiseCBRef = null;
            RefreshCBRef = null;
            OpenCBRef = null;
            OutputCBRef = null;
            OutputWCBRef = null;
            IdleCBRef = null;
            LineNumCBRef = null;
        }

        bool _FormClosing = false;
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            _FormClosing = true;
            if (TNG.IsRunning())
                TNG.ExitForce();
        }

        private void MainForm_ResizeEnd(object sender, EventArgs e)
        {
            lvGCode.Columns[0].Width = -2;
        }

        private void lvGCode_RetrieveVirtualItem(object sender, RetrieveVirtualItemEventArgs e)
        {
            ListViewItem item = new ListViewItem();

            IntPtr linep = TNG.GetLine(e.ItemIndex);
            item.Text = System.Runtime.InteropServices.Marshal.PtrToStringAnsi(linep);
            TNG.FreeString(linep);

            e.Item = item;
        }

        private volatile TNG.__InitialiseCB InitialiseCBRef = null;
        private void InitialiseCB(Int32 i)
        {
            _Init = i == 1;

            if (_Init)
            {
                InitializeCommands();
            }
            else
            {
                if (!this.IsDisposed && !_FormClosing)
                    this.BeginInvoke(new Action(() => DisableCommands()));
            }
        }


        volatile int _RefreshCBCnt = 0;
        private volatile TNG.__RefreshCB RefreshCBRef = null;
        private void RefreshCB()
        {
            if (!this.IsDisposed && _RefreshCBCnt == 0)
            {
                _RefreshCBCnt++;
                this.BeginInvoke(new Action(UpdateAll));
            }
        }

        string _Filename;
        string _FilenameLast;
        int _LineCount = 0;
        private volatile TNG.__OpenCB OpenCBRef = null;
        private void OpenCB(Int32 i)
        {
            if (i == 1)
            {
                IntPtr fnp = TNG.GetFnW();
                _Filename = _FilenameLast = System.Runtime.InteropServices.Marshal.PtrToStringUni(fnp);
                TNG.FreeString(fnp);
            }
            else
            {
                _Filename = "";
            }

            _LineCount = TNG.GetLineCount();
        }

        private volatile TNG.__OutputCB OutputCBRef = null;
        private void OutputCB(IntPtr sptr)
        {
            string str = System.Runtime.InteropServices.Marshal.PtrToStringAnsi(sptr);
            TNG.FreeString(sptr);

            if (!_FormClosing && !this.IsDisposed)
            {
                this.Invoke((MethodInvoker)delegate
                {
                    txtResult.Text += str.TrimEnd('\n');
                    if (str.EndsWith("\n"))
                        txtResult.Text += Environment.NewLine;
                });
            }
        }
        private volatile TNG.__OutputWCB OutputWCBRef = null;
        private void OutputWCB(IntPtr sptr)
        {
            string str = System.Runtime.InteropServices.Marshal.PtrToStringUni(sptr);
            TNG.FreeStringW(sptr);

            if (!_FormClosing && !this.IsDisposed)
            {
                this.Invoke((MethodInvoker)delegate
                {
                    txtResult.Text += str.TrimEnd('\n');
                    if (str.EndsWith("\n"))
                        txtResult.Text += Environment.NewLine;
                });
            }
        }

        private volatile TNG.__IdleCB IdleCBRef = null;
        private void IdleCB()
        {
            if (!_FormClosing && !this.IsDisposed)
            {
                this.Invoke((MethodInvoker)delegate
                {
                    txtResult.Text += "IdleCB " + TNG.GetLineNum().ToString() + Environment.NewLine;
                });
            }
        }

        private volatile TNG.__LineNumCB LineNumCBRef = null;
        private void LineNumCB(Int32 i)
        {
            if (!_FormClosing && !this.IsDisposed)
            {
                this.Invoke((MethodInvoker)delegate
                {
                    txtResult.Text += "LineNumCB " + i.ToString() + Environment.NewLine;
                });
            }
        }


        Thread _TNGThread;
        bool _DoHide;


        private void TNGThreadBegin()
        {
            miTNGRunShow.Text = "Exit";
            miTNGRunHide.Text = "Exit";
        }
        private void TNGThreadEnd()
        {
            miTNGRunShow.Text = "Run";
            miTNGRunHide.Text = "Run Hidden";
        }
        private void TNGThread()
        {
            try
            {
                TNG.GetVer();
            }
            catch
            {
                MessageBox.Show("TNG is not available", "", MessageBoxButtons.OK);
                return;
            }

            if (TNG.IsRunning())
            {
                MessageBox.Show("TNG already running", "", MessageBoxButtons.OK);
                return;
            }

            if (TNG.IsRunningExt())
            {
                MessageBox.Show("TNG already running as external process", "", MessageBoxButtons.OK);
                //return;
            }

            if (!_FormClosing && !this.IsDisposed)
                this.Invoke(new Action(TNGThreadBegin));

            TNG.SetInitialiseCB(InitialiseCBRef);
            TNG.SetRefreshCB(RefreshCBRef);
            TNG.SetOpenCB(OpenCBRef);
            TNG.SetOutputCB(OutputCBRef);
            TNG.SetOutputWCB(OutputWCBRef);
            TNG.SetIdleCB(IdleCBRef);
            TNG.SetLineNumCB(LineNumCBRef);

            TNG.Run(_DoHide);
            //TNG.RunProfile(_DoHide, "MyProfile");

            if (!_FormClosing && !this.IsDisposed)
                this.Invoke(new Action(TNGThreadEnd));
        }

        #region Menu TNG
        private void miTNGRunShow_Click(object sender, EventArgs e)
        {
            if ((_TNGThread != null) && _TNGThread.IsAlive)
            {
                TNG.ExitForce();
            }
            else
            {
                _DoHide = false;
                _TNGThread = new Thread(new ThreadStart(TNGThread));
                _TNGThread.Start();
            }
        }

        private void miTNGRunHide_Click(object sender, EventArgs e)
        {
            if ((_TNGThread != null) && _TNGThread.IsAlive)
            {
                TNG.ExitForce();
            }
            else
            {
                _DoHide = true;
                _TNGThread = new Thread(new ThreadStart(TNGThread));
                _TNGThread.Start();
            }
        }

        private void miTNGShowHide_Click(object sender, EventArgs e)
        {
            if (TNG.IsVisible())
                TNG.Hide();
            else
                TNG.Show();
        }

        #endregion

        #region Menu File
        private void miFileClose_Click(object sender, EventArgs e)
        {
            //int id = Convert.ToInt32(miFileClose.Tag);
            //if (id > 0)
            //{
            //    bool enbl = TNG.IsCmdEnabled(id);
            //    if (enbl)
            //    {
            //        TNG.CmdExec(id);
            //    }
            //}
            if (TNG.IsCloseEnabled())
                TNG.Close();
        }

        private void miFileOpen_Click(object sender, EventArgs e)
        {
            //int id = Convert.ToInt32(miFileOpen.Tag);
            //if (id > 0)
            //{
            //    bool enbl = TNG.IsCmdEnabled(id);
            //    if (enbl)
            //    {
            //        TNG.CmdExec(id);
            //    }
            //}
            if (TNG.IsOpenEnabled())
                TNG.Open();
        }

        private void miFileOpenLast_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miFileOpenLast.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExecStr(id, _FilenameLast);
                }
            }
        }

        private double Deg2Rad(double angle)
        {
            return Math.PI * angle / 180.0;
        }
        private double Rad2Deg(double angle)
        {
            return angle * (180.0 / Math.PI);
        }

        private void miFileLissajous_Click(object sender, EventArgs e)
        {
            txtResult.Text = "";

            if (!TNG.IsOpenEnabled())
                return;

            double x = 0;
            double y = 0;
            //double z = 0;
            double A = 1;
            double B = 1;
            double A2 = 2;
            double B2 = 5;
            double A3 = 0;
            double B3 = 0;
            double scale = 100;
            double res = 1;


            IntPtr list = TNG.LineListCreate();
            if (TNG.LineListAddAllowed(list))
            {
                TNG.LineListAdd(list, "%");
                double angle = 0;
                while (angle < 360)
                {
                    double xx = A * Math.Sin(Deg2Rad(A2 * angle + A3));
                    double yy = B * Math.Cos(Deg2Rad(B2 * angle + B3));

                    TNG.LineListAdd(list, "G01 X" + (x + (scale * xx)).ToString("0.000", CultureInfo.InvariantCulture.NumberFormat) + " Y" + (y + (scale * yy)).ToString("0.000", CultureInfo.InvariantCulture.NumberFormat));

                    angle += res;

                    TNG.SetProgress(angle / 360);
                }
                TNG.LineListAdd(list, "%");

                int cnt = TNG.LineListCount(list);
                TNG.SetProgress(0);
                TNG.SetStatus(cnt + " lines generated");

                int test = TNG.TestLineList(list);
                if (test == 0)
                {
                    TNG.OpenLineList(list);
                }
                else
                {
                    IntPtr sptr = TNG.LineListGet(list, test - 1);
                    string str = System.Runtime.InteropServices.Marshal.PtrToStringAnsi(sptr);
                    TNG.FreeStringW(sptr);
                    txtResult.Text += "Error in line " + test.ToString() + Environment.NewLine;
                    txtResult.Text += " Line: " + str + Environment.NewLine;
                }
            }
            else
            {
                txtResult.Text += "Adding lines is not allowed" + Environment.NewLine;
            }
            TNG.LineListFree(list);
        }

        private void miFileExit_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miFileExit.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }
        #endregion

        #region Menu Program
        private void miProgramCopy_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miProgramCopy.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void miProgramPaste_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miProgramPaste.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }
        #endregion


        #region Menu Machine
        private void miMachineEStop_Click(object sender, EventArgs e)
        {
            if (TNG.IsEStopEnabled())
                TNG.EStopToggle();
        }

        private void miMachineStart_Click(object sender, EventArgs e)
        {
            if (TNG.IsStartEnabled())
                TNG.Start();
        }

        private void miMachineStop_Click(object sender, EventArgs e)
        {
            if (TNG.IsStopEnabled())
                TNG.Stop();
        }

        private void miMachinePause_Click(object sender, EventArgs e)
        {
            if (TNG.IsPauseEnabled())
                TNG.PauseToggle();
        }

        private void miMachineMist_Click(object sender, EventArgs e)
        {

            int id = Convert.ToInt32(miMachineMist.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void miMachineFlood_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miMachineFlood.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void miMachineSpindle_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(miMachineSpindle.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void miMachineOut1_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(0, !miMachineOut1.Checked);
            }
        }

        private void miMachineOut2_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(1, !miMachineOut2.Checked);
            }
        }

        private void miMachineOut3_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(2, !miMachineOut3.Checked);
            }
        }

        private void miMachineOut4_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(3, !miMachineOut4.Checked);
            }
        }

        private void miMachineOut5_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(4, !miMachineOut5.Checked);
            }
        }

        private void miMachineOut6_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(5, !miMachineOut6.Checked);
            }
        }

        private void miMachineOut7_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(6, !miMachineOut7.Checked);
            }
        }

        private void miMachineOut8_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.Output(7, !miMachineOut8.Checked);
            }
        }

        private void miMachineOutPWM1_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.OutputPWM(0, 7500, 33.0);
            }
        }

        private void miMachineOutPWM2_Click(object sender, EventArgs e)
        {
            if (TNG.IsOutputEnabled())
            {
                TNG.OutputPWM(1, 12500, 66.0);
            }
        }

        private void miMachineI2C1_Click(object sender, EventArgs e)
        {
            txtResult.Clear();

            if (TNG.IsOutputEnabled())
            {
                bool res;

                byte[] data = new byte[2];

                //Set to altimeter with an OSR=128
                data[0] = 0x26;
                data[1] = 0xB8;
                res = TNG.I2C(192, data, 2);
                if (!res)
                {
                    txtResult.Text += "I2C Error" + Environment.NewLine;
                    return;
                }

                //Enable Data Flags in PT_DATA_CFG
                data[0] = 0x13;
                data[1] = 0x07;
                res = TNG.I2C(192, data, 2);
                if (!res)
                {
                    txtResult.Text += "I2C Error" + Environment.NewLine;
                    return;
                }

                //Set Active   
                data[0] = 0x26;
                data[1] = 0xB9;
                res = TNG.I2C(192, data, 2);
                if (!res)
                {
                    txtResult.Text += "I2C Error" + Environment.NewLine;
                    return;
                }

                bool rdy = false;
                int retry = 0;
                while (retry++ < 10)
                {
                    //Read STATUS Register
                    data[0] = 0;
                    byte[] status = new byte[1];
                    res = TNG.I2Cret(192, data, 1, status, 1);
                    if (!res)
                    {
                        txtResult.Text += "I2C Error" + Environment.NewLine;
                        return;
                    }

                    rdy = (status[0] & 8) != 0;
                    if (rdy)
                    {
                        data[0] = 1;
                        byte[] b1 = new byte[1];
                        res = TNG.I2Cret(192, data, 1, b1, 1);
                        if (!res)
                        {
                            txtResult.Text += "I2C Error" + Environment.NewLine;
                            return;
                        }

                        data[0] = 2;
                        byte[] b2 = new byte[1];
                        res = TNG.I2Cret(192, data, 1, b2, 1);
                        if (!res)
                        {
                            txtResult.Text += "I2C Error" + Environment.NewLine;
                            return;
                        }

                        data[0] = 3;
                        byte[] b3 = new byte[1];
                        res = TNG.I2Cret(192, data, 1, b3, 1);
                        if (!res)
                        {
                            txtResult.Text += "I2C Error" + Environment.NewLine;
                            return;
                        }

                        data[0] = 4;
                        byte[] b4 = new byte[1];
                        res = TNG.I2Cret(192, data, 1, b4, 1);
                        if (!res)
                        {
                            txtResult.Text += "I2C Error" + Environment.NewLine;
                            return;
                        }

                        data[0] = 5;
                        byte[] b5 = new byte[1];
                        res = TNG.I2Cret(192, data, 1, b5, 1);
                        if (!res)
                        {
                            txtResult.Text += "I2C Error" + Environment.NewLine;
                            return;
                        }

                        double temp = b4[0] + b5[0] / 256.0;
                        txtResult.Text += "I2C Temparure: " + temp.ToString("0.00") + Environment.NewLine;
                        return;
                    }

                }
            }
        }

        #endregion

        #region Menu Help
        private void miHelpAbout_Click(object sender, EventArgs e)
        {
            IntPtr fnp = TNG.GetLibPathW();
            string libPath = System.Runtime.InteropServices.Marshal.PtrToStringUni(fnp);
            TNG.FreeString(fnp);

            string str = System.Runtime.InteropServices.Marshal.PtrToStringAnsi(TNG.GetVersionString());
            string profn = System.Runtime.InteropServices.Marshal.PtrToStringUni(TNG.GetProfileNameStringW());
            string profp = System.Runtime.InteropServices.Marshal.PtrToStringUni(TNG.GetProfilePathStringW());
            string desc = System.Runtime.InteropServices.Marshal.PtrToStringUni(TNG.GetDescriptionStringW());

            string msg = str + Environment.NewLine +
                "Path: " + libPath + Environment.NewLine +
                "Profile Name: " + profn + Environment.NewLine +
                "Profile Path: " + profp + Environment.NewLine +
                "Description: " + desc;

            //MessageBox.Show(msg, "About", MessageBoxButtons.OK);
            TNG.PrintW(msg);
            TNG.MsgW(msg);
        }
        #endregion

        #region Buttons Top
        private void btnEStop_Click(object sender, EventArgs e)
        {
            miMachineEStop.PerformClick();
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            miFileOpen.PerformClick();
        }
        private void btnStart_Click(object sender, EventArgs e)
        {
            miMachineStart.PerformClick();
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            miMachineStop.PerformClick();
        }

        private void btnPause_Click(object sender, EventArgs e)
        {
            miMachinePause.PerformClick();
        }

        private void btnMist_Click(object sender, EventArgs e)
        {
            miMachineMist.PerformClick();
        }

        private void btnFlood_Click(object sender, EventArgs e)
        {
            miMachineFlood.PerformClick();
        }

        private void btnSpindle_Click(object sender, EventArgs e)
        {
            miMachineSpindle.PerformClick();
        }

        #endregion

        #region Buttons Left
        private void btnMoveToZero_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnMoveToZero.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnOffsetZero_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnOffsetZero.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnOffsetXY_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnOffsetXY.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnOffsetZ_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnOffsetZ.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    //TNG.CmdExec(id); //option 1
                    TNG.CmdExecIntVal(id, 2, 10); //option 2 or 3
                }
            }
        }

        private void btnOffsetMeasure_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnOffsetMeasure.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnToolMeasure_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnToolMeasure.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnHome_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnHome.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }
        #endregion

        #region Buttons Pos
        private void btnX_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnX.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnY_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnY.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnZ_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnZ.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnA_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnA.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnB_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnB.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnC_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnC.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnU_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnU.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnV_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnV.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnW_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnW.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWX_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWX.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWY_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWY.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWZ_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWZ.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWA_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWA.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWB_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWB.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWC_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWC.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWU_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWU.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWV_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWV.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnWW_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnWW.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }
        #endregion

        #region Buttons Speed
        private void btnSpeedOvrdDec_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnSpeedOvrdDec.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnSpeedOvrdInc_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnSpeedOvrdInc.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExec(id);
                }
            }
        }

        private void btnSpindleOvrdDec_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnSpindleOvrdDec.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExecVal(id, 0.05);
                }
            }
        }

        private void btnSpindleOvrdInc_Click(object sender, EventArgs e)
        {
            int id = Convert.ToInt32(btnSpindleOvrdInc.Tag);
            if (id > 0)
            {
                bool enbl = TNG.IsCmdEnabled(id);
                if (enbl)
                {
                    TNG.CmdExecVal(id, 0.05);
                }
            }
        }
        #endregion

        #region Evaluate
        private void btnEvaluate_Click(object sender, EventArgs e)
        {
            txtResult.Clear();
            double res = TNG.EvaluateW(txtCmd.Text);
            txtResult.Text += "Evaluate Result: " + res.ToString("0.000") + Environment.NewLine;
        }

        private void btnEvaluate1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "2+3*5";
        }

        private void btnEvaluate2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "dist = sqrt(_hw_motor_x*_hw_motor_x + _hw_motor_y*_hw_motor_y)";
        }

        private void btnEvaluate3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "print('PlanetCNC TNG is the best!')";
        }

        #endregion

        #region Param

        private void btnParam_Click(object sender, EventArgs e)
        {
            txtResult.Clear();


            string[] s = txtCmd.Text.Split('=');
            if (s.Length > 1)
            {
                double val = Convert.ToDouble(s[1]);
                bool res = TNG.SetParam(s[0], val);
                txtResult.Text += "Param Result: " + res.ToString() + Environment.NewLine;
            }
            else
            {
                double res = TNG.GetParam(txtCmd.Text);
                txtResult.Text += "Param Result: " + res.ToString("0.000") + Environment.NewLine;
            }

        }

        private void btnParam1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "_units";
        }

        private void btnParam2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "_units=20";
        }

        private void btnParam3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "_units=21";
        }

        #endregion

        #region Open
        private void btnOpenFn_Click(object sender, EventArgs e)
        {
            txtResult.Clear();

            if (txtCmd.Text == "")
                return;

            bool isFile = txtCmd.Text.StartsWith(".") || txtCmd.Text.StartsWith("/") || txtCmd.Text.StartsWith("\\") || (txtCmd.Text[1] == ':');

            if (isFile)
            {
                bool res = TNG.OpenFn(txtCmd.Text);
                txtResult.Text += "OpenFn Result: " + res.ToString() + Environment.NewLine;
            }
            else
            {
                bool res = TNG.OpenCode(txtCmd.Text);
                txtResult.Text += "OpenCode Result: " + res.ToString() + Environment.NewLine;
            }
        }

        private void btnOpenFn1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "../../Samples/Mickey.nc";
        }

        private void btnOpenFn2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "%" + Environment.NewLine +
            "G17 G21 G90" + Environment.NewLine +
            "G00 X-25 Y-25" + Environment.NewLine +
            "G01 X-25 Y25" + Environment.NewLine +
            "G01 X25 Y25" + Environment.NewLine +
            "G01 X25 Y-25" + Environment.NewLine +
            "G01 X-25 Y-25" + Environment.NewLine +
            "%" + Environment.NewLine;
        }

        private void btnOpenFn3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "(print,This is OpenCode example)";
        }
        #endregion

        #region Start
        private void btnStartFn_Click(object sender, EventArgs e)
        {
            txtResult.Clear();

            if (txtCmd.Text == "")
                return;

            bool isFile = txtCmd.Text.StartsWith(".") || txtCmd.Text.StartsWith("/") || txtCmd.Text.StartsWith("\\") || (txtCmd.Text[1] == ':');

            if (isFile)
            {
                bool res = TNG.StartFn(txtCmd.Text);
                txtResult.Text += "StartFn Result: " + res.ToString() + Environment.NewLine;
            }
            else
            {
                bool res = TNG.StartCode(txtCmd.Text);
                txtResult.Text += "StartCode Result: " + res.ToString() + Environment.NewLine;
            }
        }

        private void btnStartFn1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "../../Samples/Mickey.nc";
        }

        private void btnStartFn2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "%" + Environment.NewLine +
                "G17 G21 G90" + Environment.NewLine +
                "G00 X-25 Y-25" + Environment.NewLine +
                "G01 X-25 Y25" + Environment.NewLine +
                "G01 X25 Y25" + Environment.NewLine +
                "G01 X25 Y-25" + Environment.NewLine +
                "G01 X-25 Y-25" + Environment.NewLine +
                "%" + Environment.NewLine;
        }

        private void btnStartFn3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "(print,This is StartCode example)";
        }
        #endregion

        #region Test
        private void btnTestFn_Click(object sender, EventArgs e)
        {
            txtResult.Clear();

            if (txtCmd.Text == "")
                return;

            bool isFile = txtCmd.Text.StartsWith(".") || txtCmd.Text.StartsWith("/") || txtCmd.Text.StartsWith("\\") || (txtCmd.Text[1] == ':');

            if (isFile)
            {
                int res = TNG.TestFn(txtCmd.Text);
                if (res == 0)
                    txtResult.Text += "TestFn Result: No errors" + Environment.NewLine;
                else if (res > 0)
                    txtResult.Text += "TestFn Result: Error in line: " + res.ToString() + Environment.NewLine;
                else
                    txtResult.Text += "TestFn Result: Error" + Environment.NewLine;
            }
            else
            {
                int res = TNG.TestCode(txtCmd.Text);
                if (res == 0)
                    txtResult.Text += "TestCode Result: No errors" + Environment.NewLine;
                else if (res > 0)
                    txtResult.Text += "TestCode Result: Error in line: " + res.ToString() + Environment.NewLine;
                else
                    txtResult.Text += "TestCode Result: Error" + Environment.NewLine;
            }
        }

        private void btnTestFn1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "../../Samples/Mickey.nc";
        }

        private void btnTestFn2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "%" + Environment.NewLine +
                "G17 G21 G90" + Environment.NewLine +
                "G00 X-25 Y-25" + Environment.NewLine +
                "G01 X-25 Y25" + Environment.NewLine +
                "G01 G00 X25 Y25 ;error" + Environment.NewLine +
                "G01 X25 Y-25" + Environment.NewLine +
                "G01 X-25 Y-25" + Environment.NewLine +
                "%" + Environment.NewLine;
        }

        private void btnTestFn3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "print,This is TestCode example with error)";
        }
        #endregion

        #region Cmd
        private void btnCmd_Click(object sender, EventArgs e)
        {
            txtResult.Clear();

            if (txtCmd.Text == "")
                return;

            int id = TNG.GetCmdIdW(txtCmd.Text);

            if (id == 0)
            {
                txtResult.Text += "Cmd Result: Command does not exist" + Environment.NewLine;
                return;
            }

            bool en = TNG.IsCmdEnabled(id);
            bool ch = TNG.IsCmdChecked(id);

            IntPtr namep = TNG.GetCmdDisplayName(id);
            string name = System.Runtime.InteropServices.Marshal.PtrToStringAnsi(namep);
            TNG.FreeString(namep);

            bool res = false;
            if (en)
                res = TNG.CmdExec(id);

            txtResult.Text += "Cmd '" + name + "'" + Environment.NewLine;
            txtResult.Text += "  Enabled: " + en.ToString() + Environment.NewLine;
            txtResult.Text += "  Checked: " + ch.ToString() + Environment.NewLine;
            txtResult.Text += "  Result: " + res.ToString() + Environment.NewLine;
        }

        private void btnCmd1_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "File.Settings_...";
        }

        private void btnCmd2_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "View.Zoom_In";
        }

        private void btnCmd3_Click(object sender, EventArgs e)
        {
            txtCmd.Text = "View.Zoom_Out";
        }
        #endregion


        private void btnDebug_Click(object sender, EventArgs e)
        {
#if (false)
            for (int i = 0; i < 32; i++)
            {
                TNG.SPIpin(2, i + 1, true, 4);
                Thread.Sleep(200);
            }

            for (int i = 0; i < 32; i++)
            {
                TNG.SPIpin(2, i + 1, false, 4);
                Thread.Sleep(200);
            }
#endif

#if (false)
            bool res;
            while (TNG.IsControllerRunning())
            {
                Thread.Sleep(10);
            }
            res = TNG.StartCode("G53 G01 X100 Y0 F1000");
            txtResult.Text += "StartCode: " + res.ToString() + Environment.NewLine;

            while (TNG.IsControllerRunning())
            {
                Thread.Sleep(10);
            }
            res = TNG.StartCode("G53 G01 X50 Y0 F1000");
            txtResult.Text += "StartCode: " + res.ToString() + Environment.NewLine;
#endif

#if (false)
            bool res;
            while (TNG.IsControllerRunning())
            {
                Thread.Sleep(10);
            }
            res = TNG.Move3(1000, 100, 0, 0);
            txtResult.Text += "Move3: " + res.ToString() + Environment.NewLine;

            while (TNG.IsControllerRunning())
            {
                Thread.Sleep(10);
            }
            res = TNG.Move3(1000, 50, 0, 0);
            txtResult.Text += "Move3: " + res.ToString() + Environment.NewLine;
#endif

#if (true)
            bool res;
            while (TNG.IsControllerRunning())
            {
                Thread.Sleep(10);
            }
            res = TNG.Move3(1000, 100, 0, 0);
            txtResult.Text += "Move3: " + res.ToString() + Environment.NewLine;
#endif

#if (false)
            //TNG.CmdExecStr(5, "../../Samples/Mickey.nc"); //fileOpenFile
#endif
        }





        #region Jog
        double _JogX, _JogY;
        private void jogBox_Paint(object sender, PaintEventArgs e)
        {
            int x = (int)((_JogX * jogBox.Size.Width) / (+2.0) + (jogBox.Size.Width / 2.0));
            int y = (int)((_JogY * jogBox.Size.Height) / (-2.0) + (jogBox.Size.Height / 2.0));

            e.Graphics.DrawEllipse(new Pen(Color.Red, 1f), x - 5, y - 5, 10, 10);
        }

        private void jogBox_MouseUp(object sender, MouseEventArgs e)
        {
            _JogX = 0;
            _JogY = 0;
            TNG.JogStop();

            lblJogX.Text = "JX: " + _JogX.ToString("0.00");
            lblJogY.Text = "JY: " + _JogY.ToString("0.00");
            jogBox.Refresh();
        }

        private void jogBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                _JogX = +2.0 * (e.Location.X - (jogBox.Size.Width / 2.0)) / jogBox.Size.Width;
                if (_JogX > +1) _JogX = +1;
                if (_JogX < -1) _JogX = -1;

                _JogY = -2.0 * (e.Location.Y - (jogBox.Size.Height / 2.0)) / jogBox.Size.Height;
                if (_JogY > +1) _JogY = +1;
                if (_JogY < -1) _JogY = -1;

                TNG.Jog(false, _JogX, _JogY, 0);
            }
            else
            {
                _JogX = 0;
                _JogY = 0;
                TNG.JogStop();
            }

            lblJogX.Text = "JX: " + _JogX.ToString("0.00");
            lblJogY.Text = "JY: " + _JogY.ToString("0.00");
            jogBox.Refresh();
        }
        #endregion




        int _LineNum = -1;
        private void UpdateAll()
        {
            try
            {
                EnableCommands();

                UpdateDisplay();

                if (_Filename == "")
                    this.Text = "Demo";
                else
                    this.Text = "Demo - " + _Filename;

                if (lvGCode.VirtualListSize != _LineCount)
                {
                    lvGCode.BeginUpdate();
                    try
                    {
                        lvGCode.VirtualListSize = _LineCount;
                    }
                    finally
                    {
                        lvGCode.EndUpdate();
                    }
                }

                int lineNum = TNG.GetLineNum();
                if (lineNum != _LineNum)
                {
                    _LineNum = lineNum;
                    if (lineNum >= 0 && lineNum < lvGCode.Items.Count)
                    {
                        lvGCode.Items[lineNum].Selected = true;
                        lvGCode.EnsureVisible(lineNum);
                    }
                    else
                    {
                        lvGCode.SelectedIndices.Clear();
                    }
                }

            }
            catch
            {
                this.Text = "EXCEPTION";
            }

            if (_RefreshCBCnt > 0)
                _RefreshCBCnt--;
        }


        void InitializeCommands()
        {
            int id;

            #region File
            //id = TNG.GetCmdIdFromMdiW("CLOSE");
            id = TNG.GetCmdIdW("File.Close");
            miFileClose.Tag = id;

            //id = TNG.GetCmdIdFromMdiW("OPEN");
            id = TNG.GetCmdIdW("File.Open_...");
            miFileOpen.Tag = id;

            id = TNG.GetCmdIdW("File.Open_File");
            miFileOpenLast.Tag = id;

            id = TNG.GetCmdIdW("File.Exit");
            miFileExit.Tag = id;
            #endregion

            #region Program
            id = TNG.GetCmdIdW("Program.Copy_To_Clipboard");
            miProgramCopy.Tag = id;

            id = TNG.GetCmdIdW("Program.Paste_From_Clipboard");
            miProgramPaste.Tag = id;
            #endregion

            #region Machine
            id = TNG.GetCmdIdW("Machine.Mist");
            miMachineMist.Tag = id;

            id = TNG.GetCmdIdW("Machine.Flood");
            miMachineFlood.Tag = id;

            id = TNG.GetCmdIdW("Machine.Spindle");
            miMachineSpindle.Tag = id;
            #endregion

            #region Left
            id = TNG.GetCmdIdW("Machine.Move.To_Zero");
            btnMoveToZero.Tag = id;

            id = TNG.GetCmdIdW("Machine.Work_Position.Offset.To_Zero");
            btnOffsetZero.Tag = id;

            id = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.XY");
            btnOffsetXY.Tag = id;

            //id = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.Z"); //option 1
            //id = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero"); //option 2
            id = TNG.GetCmdIdW("Machine.Work_Position.To_Value_..."); //option 3
            btnOffsetZ.Tag = id;

            id = TNG.GetCmdIdW("Machine.Work_Position.Measure_Height");
            btnOffsetMeasure.Tag = id;

            id = TNG.GetCmdIdW("Machine.Tool_Offset.Measure_Length");
            btnToolMeasure.Tag = id;

            id = TNG.GetCmdIdW("Machine.Home");
            btnHome.Tag = id;
            #endregion

            #region Position
            btnX.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.X");
            btnY.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.Y");
            btnZ.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.Z");
            btnA.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.A");
            btnB.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.B");
            btnC.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.C");
            btnU.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.U");
            btnV.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.V");
            btnW.Tag = TNG.GetCmdIdW("Machine.Machine_Position.Axis_To_Zero.W");

            btnWX.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.X");
            btnWY.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.Y");
            btnWZ.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.Z");
            btnWA.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.A");
            btnWB.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.B");
            btnWC.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.C");
            btnWU.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.U");
            btnWV.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.V");
            btnWW.Tag = TNG.GetCmdIdW("Machine.Work_Position.Axis_To_Zero.W");
            #endregion

            #region Speed
            btnSpeedOvrdDec.Tag = TNG.GetCmdIdW("Machine.Options.Override.Feed.Decrease");
            btnSpeedOvrdInc.Tag = TNG.GetCmdIdW("Machine.Options.Override.Feed.Increase");
            btnSpindleOvrdDec.Tag = TNG.GetCmdIdW("Machine.Options.Override.Spindle.Decrease");
            btnSpindleOvrdInc.Tag = TNG.GetCmdIdW("Machine.Options.Override.Spindle.Increase");
            #endregion

        }

        void DisableCommands()
        {
            #region File
            miFileClose.Enabled = false;

            miFileOpen.Enabled = false;
            btnOpen.Enabled = miFileOpen.Enabled;

            miFileOpenLast.Enabled = false;

            miFileLissajous.Enabled = false;

            miFileExit.Enabled = false;
            #endregion

            #region Program
            miProgramCopy.Enabled = false;

            miProgramPaste.Enabled = false;
            #endregion

            #region Machine
            miMachineEStop.Enabled = false;
            btnEStop.Enabled = miMachineEStop.Enabled;

            miMachineStop.Enabled = false;
            btnStop.Enabled = miMachineStop.Enabled;

            miMachinePause.Enabled = false;
            btnPause.Enabled = miMachinePause.Enabled;

            miMachineStart.Enabled = false;
            btnStart.Enabled = miMachineStart.Enabled;


            miMachineMist.Enabled = false;
            btnMist.Enabled = miMachineMist.Enabled;

            miMachineFlood.Enabled = false;
            btnFlood.Enabled = miMachineFlood.Enabled;

            miMachineSpindle.Enabled = false;
            btnSpindle.Enabled = miMachineSpindle.Enabled;


            miMachineOut1.Enabled = false;
            miMachineOut2.Enabled = false;
            miMachineOut3.Enabled = false;
            miMachineOut4.Enabled = false;
            miMachineOut5.Enabled = false;
            miMachineOut6.Enabled = false;
            miMachineOut7.Enabled = false;
            miMachineOut8.Enabled = false;

            miMachineOutPWM1.Enabled = false;
            miMachineOutPWM2.Enabled = false;

            miMachineI2C1.Enabled = false;
            #endregion

            #region Left
            btnMoveToZero.Enabled = false;
            btnOffsetZero.Enabled = btnMoveToZero.Enabled;
            btnOffsetXY.Enabled = btnMoveToZero.Enabled;
            btnOffsetZ.Enabled = btnMoveToZero.Enabled;

            btnOffsetMeasure.Enabled = false;
            btnToolMeasure.Enabled = btnOffsetMeasure.Enabled;
            btnHome.Enabled = btnOffsetMeasure.Enabled;
            #endregion
        }

        void EnableCommands()
        {
            int id;
            bool init = _Init || _InitExt;

            #region File
            //id = Convert.ToInt32(miFileClose.Tag);
            //miFileClose.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            miFileClose.Enabled = TNG.IsCloseEnabled();

            //id = Convert.ToInt32(miFileOpen.Tag);
            //miFileOpen.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            miFileOpen.Enabled = TNG.IsOpenEnabled();
            btnOpen.Enabled = miFileOpen.Enabled;

            id = Convert.ToInt32(miFileOpenLast.Tag);
            miFileOpenLast.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));

            miFileLissajous.Enabled = miFileOpen.Enabled;

            id = Convert.ToInt32(miFileExit.Tag);
            miFileExit.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            #endregion

            #region Program
            id = Convert.ToInt32(miProgramCopy.Tag);
            miProgramCopy.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));

            id = Convert.ToInt32(miProgramPaste.Tag);
            miProgramPaste.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            #endregion

            #region Machine
            miMachineEStop.Enabled = init && TNG.IsEStopEnabled();
            btnEStop.Enabled = miMachineEStop.Enabled;
            miMachineEStop.Checked = init && TNG.IsEStop();
            btnEStop.Checked = miMachineEStop.Checked;

            miMachineStop.Enabled = init && TNG.IsStopEnabled();
            btnStop.Enabled = miMachineStop.Enabled;

            miMachinePause.Enabled = init && TNG.IsPauseEnabled();
            btnPause.Enabled = miMachinePause.Enabled;
            miMachinePause.Checked = init && TNG.IsPause();
            btnPause.Checked = miMachinePause.Checked;

            miMachineStart.Enabled = init && TNG.IsStartEnabled();
            btnStart.Enabled = miMachineStart.Enabled;


            id = Convert.ToInt32(miMachineMist.Tag);
            miMachineMist.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            btnMist.Enabled = miMachineMist.Enabled;
            miMachineMist.Checked = init && (id > 0) && TNG.IsCmdChecked(id);
            btnMist.Checked = miMachineMist.Checked;

            id = Convert.ToInt32(miMachineFlood.Tag);
            miMachineFlood.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            btnFlood.Enabled = miMachineFlood.Enabled;
            miMachineFlood.Checked = init && (id > 0) && TNG.IsCmdChecked(id);
            btnFlood.Checked = miMachineFlood.Checked;

            id = Convert.ToInt32(miMachineSpindle.Tag);
            miMachineSpindle.Enabled = init && (id > 0) && (TNG.IsCmdEnabled(id));
            btnSpindle.Enabled = miMachineSpindle.Enabled;
            miMachineSpindle.Checked = init && (id > 0) && TNG.IsCmdChecked(id);
            btnSpindle.Checked = miMachineSpindle.Checked;

            bool oen = TNG.IsOutputEnabled();
            miMachineOut1.Enabled = init && oen;
            miMachineOut2.Enabled = init && oen;
            miMachineOut3.Enabled = init && oen;
            miMachineOut4.Enabled = init && oen;
            miMachineOut5.Enabled = init && oen;
            miMachineOut6.Enabled = init && oen;
            miMachineOut7.Enabled = init && oen;
            miMachineOut8.Enabled = init && oen;

            miMachineOutPWM1.Enabled = init && oen;
            miMachineOutPWM2.Enabled = init && oen;

            uint o = TNG.InfoOutput();
            miMachineOut1.Checked = init && ((o & (1 << 0)) != 0);
            miMachineOut2.Checked = init && ((o & (1 << 1)) != 0);
            miMachineOut3.Checked = init && ((o & (1 << 2)) != 0);
            miMachineOut4.Checked = init && ((o & (1 << 3)) != 0);
            miMachineOut5.Checked = init && ((o & (1 << 4)) != 0);
            miMachineOut6.Checked = init && ((o & (1 << 5)) != 0);
            miMachineOut7.Checked = init && ((o & (1 << 6)) != 0);
            miMachineOut8.Checked = init && ((o & (1 << 7)) != 0);

            miMachineI2C1.Enabled = init && oen;
            #endregion

            #region Left
            btnMoveToZero.Enabled = init && TNG.IsCodeEnabled();
            btnOffsetZero.Enabled = btnMoveToZero.Enabled;
            btnOffsetXY.Enabled = btnMoveToZero.Enabled;
            btnOffsetZ.Enabled = btnMoveToZero.Enabled;

            btnOffsetMeasure.Enabled = init && TNG.IsCodeExEnabled();
            btnToolMeasure.Enabled = btnOffsetMeasure.Enabled;
            btnHome.Enabled = btnOffsetMeasure.Enabled;
            #endregion

        }

        void UpdateDisplay()
        {
            bool init = _Init || _InitExt;

            if (init)
            {
                #region Position
                double x, y, z, a, b, c, u, v, w;
                if (TNG.InfoMotorPosition9(out x, out y, out z, out a, out b, out c, out u, out v, out w))
                {
                    lblX.Text = "X: " + x.ToString("0.000"); lblY.Text = "Y: " + y.ToString("0.000"); lblZ.Text = "Z: " + z.ToString("0.000");
                    lblA.Text = "A: " + a.ToString("0.000"); lblB.Text = "B: " + b.ToString("0.000"); lblC.Text = "C: " + c.ToString("0.000");
                    lblU.Text = "U: " + u.ToString("0.000"); lblV.Text = "V: " + v.ToString("0.000"); lblW.Text = "W: " + w.ToString("0.000");
                }
                else
                {
                    lblX.Text = "X: -----"; lblY.Text = "Y: -----"; lblZ.Text = "Z: -----";
                    lblA.Text = "A: -----"; lblB.Text = "B: -----"; lblC.Text = "C: -----";
                    lblU.Text = "U: -----"; lblV.Text = "V: -----"; lblW.Text = "W: -----";
                }
                if (TNG.InfoWorkPosition9(out x, out y, out z, out a, out b, out c, out u, out v, out w))
                {
                    lblWX.Text = "WX: " + x.ToString("0.000"); lblWY.Text = "WY: " + y.ToString("0.000"); lblWZ.Text = "WZ: " + z.ToString("0.000");
                    lblWA.Text = "WA: " + a.ToString("0.000"); lblWB.Text = "WB: " + b.ToString("0.000"); lblWC.Text = "WC: " + c.ToString("0.000");
                    lblWU.Text = "WU: " + u.ToString("0.000"); lblWV.Text = "WV: " + v.ToString("0.000"); lblWW.Text = "WW: " + w.ToString("0.000");
                }
                else
                {
                    lblWX.Text = "WX: -----"; lblWY.Text = "WY: -----"; lblWZ.Text = "WZ: -----";
                    lblWA.Text = "WA: -----"; lblWB.Text = "WB: -----"; lblWC.Text = "WC: -----";
                    lblWU.Text = "WU: -----"; lblWV.Text = "WV: -----"; lblWW.Text = "WW: -----";
                }
                #endregion

                #region Speed
                lblSpeed.Text = "Speed: " + TNG.InfoSpeed().ToString("0.000");
                lblAccel.Text = "Accel: " + TNG.InfoAcceleration().ToString("0.000");
                lblSpindle.Text = "Spindle: " + TNG.InfoSpindle().ToString("0.000");

                lblSpeedOvrd.Text = ((int)(100 * TNG.GetParam("_ovrd_speedfeed"))).ToString() + "%";
                lblSpindleOvrd.Text = ((int)(100 * TNG.GetParam("_ovrd_spindle"))).ToString() + "%";
                #endregion

                #region System
                lblGetVer.Text = "GetVer:".PadRight(18, ' ') + TNG.GetVer().ToString();
                lblIsRunning.Text = "IsRunning:".PadRight(18, ' ') + TNG.IsRunning().ToString();
                lblIsRunningExt.Text = "IsRunningExt:".PadRight(18, ' ') + TNG.IsRunningExt().ToString();
                lblIsInitialized.Text = "IsInitialized:".PadRight(18, ' ') + TNG.IsInitialized().ToString();
                lblIsVisible.Text = "IsVisible:".PadRight(18, ' ') + TNG.IsVisible().ToString();
                #endregion

                #region Info
                lblInfoIsInitialized.Text = "IsInitialized:".PadRight(18, ' ') + TNG.InfoIsInitialized().ToString();
                lblInfoSerial.Text = "Serial:".PadRight(18, ' ') + TNG.InfoSerial().ToString();
                lblInfoHWVersion.Text = "HWVersion:".PadRight(18, ' ') + TNG.InfoHWVersion().ToString();
                lblInfoSWVersion.Text = "SWVersion:".PadRight(18, ' ') + TNG.InfoSWVersion().ToString();
                lblInfoIsVersionValid.Text = "IsVersionValid:".PadRight(18, ' ') + TNG.InfoIsVersionValid().ToString();

                lblInfoSpindleIdx.Text = "SpindleIdx:".PadRight(18, ' ') + TNG.InfoSpindleIdx().ToString("0.00");
                lblInfoSpindleEnc.Text = "SpindleEnc:".PadRight(18, ' ') + TNG.InfoSpindleEnc().ToString("0.00");
                lblInfoSpindleSet.Text = "SpindleSet:".PadRight(18, ' ') + TNG.InfoSpindleSet().ToString("0.00");


                lblBufferAvailable.Text = "BufAvail:".PadRight(18, ' ') + TNG.InfoBufferAvailable().ToString();
                lblBufferUtilization.Text = "BufUtil:".PadRight(18, ' ') + TNG.InfoBufferUtilization().ToString("0.000");
                #endregion

                #region Program
                lblIsLicenseValid.Text = "IsLicenseValid:".PadRight(18, ' ') + TNG.IsLicenseValid().ToString();
                lblIsUIReady.Text = "IsUIReady:".PadRight(18, ' ') + TNG.IsUIReady().ToString();
                lblIsControllerReady.Text = "IsConReady:".PadRight(18, ' ') + TNG.IsControllerReady().ToString();
                lblIsControllerRunning.Text = "IsConRunning:".PadRight(18, ' ') + TNG.IsControllerRunning().ToString(); ;
                lblIsProgramLoaded.Text = "IsProgramLoaded:".PadRight(18, ' ') + TNG.IsProgramLoaded().ToString();

                lblIsIdle.Text = "IsIdle:".PadRight(18, ' ') + TNG.IsIdle().ToString();
                lblIsEStop.Text = "IsEStop:".PadRight(18, ' ') + TNG.IsEStop().ToString();
                lblIsStop.Text = "IsStop:".PadRight(18, ' ') + TNG.IsStop().ToString();
                lblIsPause.Text = "IsPause:".PadRight(18, ' ') + TNG.IsPause().ToString();

                lblGetLineNum.Text = "GetLineNum:".PadRight(18, ' ') + TNG.GetLineNum().ToString();
                lblGetLineCount.Text = "GetLineCount:".PadRight(18, ' ') + TNG.GetLineCount().ToString();
                #endregion

                #region State
                lblUnits.Text = "Units:".PadRight(18, ' ') + TNG.GetParam("_units").ToString("0");
                lblPlane.Text = "Plane:".PadRight(18, ' ') + TNG.GetParam("_plane").ToString("0");
                lblDistanceMode.Text = "DistanceMode:".PadRight(18, ' ') + TNG.GetParam("_distancemode").ToString("0");
                lblDistanceModeIJK.Text = "DistanceModeIJK:".PadRight(18, ' ') + TNG.GetParam("_distancemode_ijk").ToString("0.0");
                lblDistanceModeABC.Text = "DistanceModeABC:".PadRight(18, ' ') + TNG.GetParam("_distancemode_abc").ToString("0.0");
                lblPolarMode.Text = "PolarMode:".PadRight(18, ' ') + TNG.GetParam("_polarmode").ToString("0");
                lblCycleReturn.Text = "CycleReturn:".PadRight(18, ' ') + TNG.GetParam("_cyclereturnmode").ToString("0");
                lblLatheMode.Text = "LatheMode:".PadRight(18, ' ') + TNG.GetParam("_lathemode").ToString("0");

                lblFeedSpeed.Text = "FeedSpeed:".PadRight(18, ' ') + TNG.GetParam("_feedspeed").ToString("0.000");
                lblSpindleSpeed.Text = "SpindleSpeed:".PadRight(18, ' ') + TNG.GetParam("_spindlespeed").ToString("0.00");
                #endregion

                #region IO
                lblInput.Text = "Input:".PadRight(18, ' ') + "0x" + TNG.InfoInput().ToString("X2");
                lblJog.Text = "Jog:".PadRight(18, ' ') + "0x" + TNG.InfoJog().ToString("X2");
                lblJogPot.Text = "JogPot:".PadRight(18, ' ') + TNG.InfoJogPot().ToString();
                lblLimit.Text = "Limit:".PadRight(18, ' ') + "0x" + TNG.InfoLimit().ToString("X2");
                lblOutput.Text = "Output:".PadRight(18, ' ') + "0x" + TNG.InfoOutput().ToString("X2");

                lblPWM1.Text = "PWM1:".PadRight(18, ' ') + TNG.InfoOutputDuty(0).ToString("0.0") + "@" + TNG.InfoOutputFreq(0).ToString("0");
                lblPWM2.Text = "PWM2:".PadRight(18, ' ') + TNG.InfoOutputDuty(1).ToString("0.0") + "@" + TNG.InfoOutputFreq(1).ToString("0");
                lblPWM3.Text = "PWM3:".PadRight(18, ' ') + TNG.InfoOutputDuty(2).ToString("0.0") + "@" + TNG.InfoOutputFreq(2).ToString("0");

                lblAux1.Text = "Aux1:".PadRight(18, ' ') + TNG.InfoAux(0).ToString();
                lblAux2.Text = "Aux2:".PadRight(18, ' ') + TNG.InfoAux(1).ToString();
                lblAux3.Text = "Aux3:".PadRight(18, ' ') + TNG.InfoAux(2).ToString();
                lblAux4.Text = "Aux4:".PadRight(18, ' ') + TNG.InfoAux(3).ToString();
                #endregion
            }
        }
    }
}

