
#ifndef __plugin_H__
#define __plugin_H__


#include <stdlib.h>		
#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include <stdarg.h>
#include <string.h>


#ifdef _WIN32
#	include <windows.h>
#endif




#ifdef __cplusplus
extern "C" {
#endif

#ifndef PCNC_CALL
#	ifdef _WIN32
#		define PCNC_CALL __cdecl
#	else
#		define PCNC_CALL
#	endif
#endif

#ifndef PCNC_EXPORT
#	ifdef _WIN32
#		define PCNC_EXPORT __declspec(dllexport)
#	else
#		define PCNC_EXPORT __attribute__((visibility("default"))) 
#	endif
#endif

#ifdef _WIN32
	typedef void(__cdecl* __InitialiseCB)(int);
	typedef void(__cdecl* __RefreshCB)();
	typedef void(__cdecl* __OpenCB)(int);
	typedef void(__cdecl* __OutputCB)(const char*);
	typedef void(__cdecl* __OutputWCB)(const wchar_t*);
	typedef void(__cdecl* __IdleCB)();
	typedef void(__cdecl* __LineNumCB)(int);
#else
	typedef void(*__InitialiseCB)(int);
	typedef void(*__RefreshCB)();
	typedef void(*__OpenCB)(int);
	typedef void(*__OutputCB)(const char*);
	typedef void(*__OutputWCB)(const wchar_t*);
	typedef void(*__IdleCB)();
	typedef void(*__LineNumCB)(int);
#endif

	//Memory
	typedef void (PCNC_CALL* FreeStringFn)(char* str);
	typedef void (PCNC_CALL* FreeStringWFn)(wchar_t* strw);

	//Callback
	typedef void (PCNC_CALL* SetInitialiseCBFn)(__InitialiseCB cb);
	typedef void (PCNC_CALL* SetRefreshCBFn)(__RefreshCB cb);
	typedef void (PCNC_CALL* SetOpenCBFn)(__OpenCB cb);
	typedef void (PCNC_CALL* SetOutputCBFn)(__OutputCB cb);
	typedef void (PCNC_CALL* SetOutputWCBFn)(__OutputWCB cb);
	typedef void (PCNC_CALL* SetIdleCBFn)(__IdleCB cb);
	typedef void (PCNC_CALL* SetLineNumCBFn)(__LineNumCB cb);

	//Run & Exit
	typedef int (PCNC_CALL* RunFn)(bool hideUI);
	typedef int (PCNC_CALL* RunProfileFn)(bool hideUI, const char* profile);
	typedef int (PCNC_CALL* RunProfileWFn)(bool hideUI, const wchar_t* profile);
	typedef void (PCNC_CALL* ExitFn)();
	typedef void (PCNC_CALL* ExitForceFn)();

	//Run status
	typedef int (PCNC_CALL* GetVerFn)();
	typedef char* (PCNC_CALL* GetLibPathFn)();
	typedef wchar_t* (PCNC_CALL* GetLibPathWFn)();

	typedef bool (PCNC_CALL* IsRunningFn)();
	typedef bool (PCNC_CALL* IsRunningExtFn)();
	typedef unsigned long long (PCNC_CALL* GetDateTimeFn)();
	typedef bool (PCNC_CALL* IsInitializedFn)();

	//Version & Profile Info
	typedef const char* (PCNC_CALL* GetVersionStringFn)();
	typedef const wchar_t* (PCNC_CALL* GetVersionStringWFn)();
	typedef const char* (PCNC_CALL* GetProfileNameStringFn)();
	typedef const wchar_t* (PCNC_CALL* GetProfileNameStringWFn)();
	typedef const char* (PCNC_CALL* GetProfilePathStringFn)();
	typedef const wchar_t* (PCNC_CALL* GetProfilePathStringWFn)();
	typedef const char* (PCNC_CALL* GetDescriptionStringFn)();
	typedef const wchar_t* (PCNC_CALL* GetDescriptionStringWFn)();

	//Screen
	typedef bool (PCNC_CALL* IsVisibleFn)();
	typedef bool (PCNC_CALL* ShowFn)();
	typedef bool (PCNC_CALL* HideFn)();
	typedef bool (PCNC_CALL* SetProgressFn)(double dbl);
	typedef bool (PCNC_CALL* SetStatusFn)(const char* str);
	typedef bool (PCNC_CALL* SetStatusWFn)(const wchar_t* strw);
	typedef bool (PCNC_CALL* MsgFn)(const char* str);
	typedef bool (PCNC_CALL* MsgWFn)(const wchar_t* strw);
	typedef bool (PCNC_CALL* PrintFn)(const char* str);
	typedef bool (PCNC_CALL* PrintWFn)(const wchar_t* strw);

	//Parameters & Eval
	typedef double (PCNC_CALL* GetParamFn)(const char* param);
	typedef double (PCNC_CALL* GetParamWFn)(const wchar_t* param);
	typedef bool (PCNC_CALL* SetParamFn)(const char* param, double value);
	typedef bool (PCNC_CALL* SetParamWFn)(const wchar_t* param, double value);
	typedef double (PCNC_CALL* EvaluateFn)(const char* expr);
	typedef double (PCNC_CALL* EvaluateWFn)(const wchar_t* expr);

	//State
	typedef bool (PCNC_CALL* IsLicenseValidFn)();
	typedef bool (PCNC_CALL* IsUIReadyFn)();
	typedef bool (PCNC_CALL* IsControllerReadyFn)();
	typedef bool (PCNC_CALL* IsControllerRunningFn)();
	typedef bool (PCNC_CALL* IsProgramLoadedFn)();

	typedef bool (PCNC_CALL* IsIdleFn)();
	typedef bool (PCNC_CALL* IsEStopFn)();
	typedef bool (PCNC_CALL* IsStopFn)();
	typedef bool (PCNC_CALL* IsPauseFn)();

	//Machine Command Status
	typedef bool (PCNC_CALL* IsEStopEnabledFn)();
	typedef bool (PCNC_CALL* IsStopEnabledFn)();
	typedef bool (PCNC_CALL* IsPauseEnabledFn)();
	typedef bool (PCNC_CALL* IsStartEnabledFn)();
	typedef bool (PCNC_CALL* IsOutputEnabledFn)();
	typedef bool (PCNC_CALL* IsCodeEnabledFn)();
	typedef bool (PCNC_CALL* IsCodeExEnabledFn)();
	typedef bool (PCNC_CALL* IsOpenEnabledFn)();
	typedef bool (PCNC_CALL* IsCloseEnabledFn)();

	//Machine Commands
	typedef bool (PCNC_CALL* EStopFn)(bool b);
	typedef bool (PCNC_CALL* EStopToggleFn)();
	typedef bool (PCNC_CALL* StopFn)();
	typedef bool (PCNC_CALL* PauseFn)(bool b);
	typedef bool (PCNC_CALL* PauseToggleFn)();
	typedef bool (PCNC_CALL* StartFn)();
	typedef bool (PCNC_CALL* OpenFn)();
	typedef bool (PCNC_CALL* CloseFn)();


	//Machine Commands Generic
	typedef int (PCNC_CALL* GetCmdCountFn)();
	typedef int (PCNC_CALL* GetCmdIdFn)(const char* str);
	typedef int (PCNC_CALL* GetCmdIdWFn)(const wchar_t* strw);
	typedef int (PCNC_CALL* GetCmdIdFromMdiFn)(const char* str);
	typedef int (PCNC_CALL* GetCmdIdFromMdiWFn)(const wchar_t* strw);

	typedef bool (PCNC_CALL* IsCmdEnabledFn)(int id);
	typedef bool (PCNC_CALL* IsCmdCheckedFn)(int id);

	typedef char* (PCNC_CALL* GetCmdNameFn)(int id);
	typedef wchar_t* (PCNC_CALL* GetCmdNameWFn)(int id);
	typedef char* (PCNC_CALL* GetCmdDisplayNameFn)(int id);
	typedef wchar_t* (PCNC_CALL* GetCmdDisplayNameWFn)(int id);
	typedef char* (PCNC_CALL* GetCmdDisplayNameWithPathFn)(int id);
	typedef wchar_t* (PCNC_CALL* GetCmdDisplayNameWithPathWFn)(int id);

	typedef bool (PCNC_CALL* CmdExecFn)(int id);

	typedef bool (PCNC_CALL* CmdExecStrFn)(int id, const char* str);
	typedef bool (PCNC_CALL* CmdExecStrWFn)(int id, const wchar_t* strw);
	typedef bool (PCNC_CALL* CmdExecValFn)(int id, double val);
	typedef bool (PCNC_CALL* CmdExecIntValFn)(int id, int num, double val);

	//Helpers
	typedef bool (PCNC_CALL* OpenFnFn)(const char* str);
	typedef bool (PCNC_CALL* OpenFnWFn)(const wchar_t* strw);
	typedef bool (PCNC_CALL* OpenCodeFn)(const char* str);
	typedef bool (PCNC_CALL* OpenCodeWFn)(const wchar_t* strw);

	typedef int (PCNC_CALL* TestFnFn)(const char* str);
	typedef int (PCNC_CALL* TestFnWFn)(const wchar_t* strw);
	typedef int (PCNC_CALL* TestCodeFn)(const char* str);
	typedef int (PCNC_CALL* TestCodeWFn)(const wchar_t* strw);

	typedef bool (PCNC_CALL* StartFnFn)(const char* str);
	typedef bool (PCNC_CALL* StartFnWFn)(const wchar_t* strw);
	typedef bool (PCNC_CALL* StartCodeFn)(const char* str);
	typedef bool (PCNC_CALL* StartCodeWFn)(const wchar_t* strw);

	//G-Code
	typedef char* (PCNC_CALL* GetFnFn)();
	typedef wchar_t* (PCNC_CALL* GetFnWFn)();
	typedef	int (PCNC_CALL* GetLineCountFn)();
	typedef	char* (PCNC_CALL* GetLineFn)(int row);
	typedef	wchar_t* (PCNC_CALL* GetLineWFn)(int row);
	typedef	int (PCNC_CALL* GetLineNumFn)();

	//Info
	typedef bool (PCNC_CALL* InfoIsInitializedFn)();
	typedef int (PCNC_CALL* InfoSerialFn)();
	typedef int (PCNC_CALL* InfoHWVersionFn)();
	typedef int (PCNC_CALL* InfoSWVersionFn)();
	typedef bool (PCNC_CALL* InfoIsVersionValidFn)();

	typedef double (PCNC_CALL* InfoWorkPositionFn)(int n);
	typedef bool (PCNC_CALL* InfoWorkPosition3Fn)(double* x, double* y, double* z);
	typedef bool (PCNC_CALL* InfoWorkPosition9Fn)(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);

	typedef double (PCNC_CALL* InfoMotorPositionFn)(int n);
	typedef bool (PCNC_CALL* InfoMotorPosition3Fn)(double* x, double* y, double* z);
	typedef bool (PCNC_CALL* InfoMotorPosition9Fn)(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);

	typedef double (PCNC_CALL* InfoWorkUnitsPositionFn)(int n);
	typedef bool (PCNC_CALL* InfoWorkUnitsPosition3Fn)(double* x, double* y, double* z);
	typedef bool (PCNC_CALL* InfoWorkUnitsPosition9Fn)(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);

	typedef double (PCNC_CALL* InfoMotorUnitsPositionFn)(int n);
	typedef bool (PCNC_CALL* InfoMotorUnitsPosition3Fn)(double* x, double* y, double* z);
	typedef bool (PCNC_CALL* InfoMotorUnitsPosition9Fn)(double* x, double* y, double* z, double* a, double* b, double* c, double* u, double* v, double* w);

	typedef double (PCNC_CALL* InfoSpeedFn)();
	typedef double (PCNC_CALL* InfoAccelerationFn)();
	typedef double (PCNC_CALL* InfoSpindleFn)();
	typedef double (PCNC_CALL* InfoSpindleIdxFn)();
	typedef double (PCNC_CALL* InfoSpindleEncFn)();
	typedef double (PCNC_CALL* InfoSpindleSetFn)();

	typedef bool (PCNC_CALL* InfoSpeedOverrideEnabledFn)();
	typedef bool (PCNC_CALL* InfoSpindleOverrideEnabledFn)();

	typedef unsigned int (PCNC_CALL* InfoInputFn)();
	typedef unsigned int (PCNC_CALL* InfoJogFn)();
	typedef unsigned int (PCNC_CALL* InfoJogPotFn)();
	typedef unsigned int (PCNC_CALL* InfoLimitFn)();
	typedef unsigned int (PCNC_CALL* InfoOutputFn)();
	typedef double (PCNC_CALL* InfoOutputFreqFn)(int num);
	typedef double (PCNC_CALL* InfoOutputDutyFn)(int num);
	typedef unsigned int (PCNC_CALL* InfoAuxFn)(int num);

	typedef unsigned int (PCNC_CALL* InfoBufferAvailableFn)();
	typedef double (PCNC_CALL* InfoBufferUtilizationFn)();

	//Direct Commands
	typedef bool (PCNC_CALL* MoveAxisFn)(double speed, int axis, double val);
	typedef bool (PCNC_CALL* Move3Fn)(double speed, double x, double y, double z);
	typedef bool (PCNC_CALL* Move9Fn)(double speed, double x, double y, double z, double a, double b, double c, double u, double v, double w);

	typedef bool (PCNC_CALL* OutputFn)(int num, bool value);
	typedef bool (PCNC_CALL* OutputPWMFn)(int num, int freq, double duty);
	typedef bool (PCNC_CALL* OutputRCFn)(int num, double value);

	typedef bool (PCNC_CALL* I2CFn)(int addr, const unsigned char* data, int len);
	typedef bool (PCNC_CALL* I2CretFn)(int addr, const unsigned char* data, int len, unsigned char* dataret, int lenret);

	typedef bool (PCNC_CALL* SPIFn)(int ssel, unsigned int value, int total);
	typedef bool (PCNC_CALL* SPIpinFn)(int ssel, int pin, bool state, int total);

	//Jog
	typedef bool (PCNC_CALL* JogStopFn)();
	typedef bool (PCNC_CALL* JogFn)(bool step, double x, double y, double z);
	typedef bool (PCNC_CALL* Jog9Fn)(bool step, double x, double y, double z, double a, double b, double c, double u, double v, double w);

	//THC
	typedef bool (PCNC_CALL* THCFn)(bool arcok, int dir);

	//G-Code Lines
	typedef void* (PCNC_CALL* LineListCreateFn)();
	typedef void (PCNC_CALL* LineListFreeFn)(void* ptr);

	typedef bool (PCNC_CALL* LineListClearFn)(void* ptr);
	typedef int (PCNC_CALL* LineListCountFn)(void* ptr);

	typedef bool (PCNC_CALL* LineListAddAllowedFn)(void* ptr);
	typedef bool (PCNC_CALL* LineListAddFn)(void* ptr, const char* str);
	typedef bool (PCNC_CALL* LineListAddWFn)(void* ptr, const wchar_t* str);

	typedef	char* (PCNC_CALL* LineListGetFn)(void* ptr, int i);
	typedef	wchar_t* (PCNC_CALL* LineListGetWFn)(void* ptr, int i);

	typedef bool (PCNC_CALL* LineListLoadFromFileFn)(void* ptr, const char* fn);
	typedef bool (PCNC_CALL* LineListLoadFromFileWFn)(void* ptr, const wchar_t* fn);

	typedef bool (PCNC_CALL* OpenLineListFn)(void* ptr);
	typedef int (PCNC_CALL* TestLineListFn)(void* ptr);
	typedef bool (PCNC_CALL* StartLineListFn)(void* ptr);

	//-----------------------------------------------------------------------------------------------
	PCNC_EXPORT void Initialize();
	PCNC_EXPORT void Shutdown();

	PCNC_EXPORT bool MetamorphFor();
	PCNC_EXPORT bool MetamorphInv();

	//-----------------------------------------------------------------------------------------------
	PCNC_EXPORT int Call(int i);
	PCNC_EXPORT int Test(int i);


#ifdef __cplusplus
}
#endif

#endif 