
#include "plugin.h"

static HINSTANCE _hinstLib = nullptr;

PCNC_EXPORT void Initialize()
{
	printf("Plugin Initialize\n");
	_hinstLib = LoadLibraryA("PlanetCNCLib32d.dll");
}
PCNC_EXPORT void Shutdown()
{
	printf("Plugin Shutdown\n");
	if (_hinstLib)
	{
		FreeLibrary(_hinstLib);
		_hinstLib = nullptr;
	}
}

PCNC_EXPORT bool MetamorphFor()
{
	return false;
}
PCNC_EXPORT bool MetamorphInv()
{
	return false;
}




PCNC_EXPORT int Call(int i)
{
	printf("Plugin Call %d\n", i);

	if (_hinstLib)
	{
		PrintFn printFn = (PrintFn)GetProcAddress(_hinstLib, "Print");
		if (printFn)
		{
			printFn("Plugin Call");
		}
	}
	return 0;
}


PCNC_EXPORT int Test(int i)
{
	printf("Plugin Test %d\n", i);

	if (_hinstLib)
	{
		PrintFn printFn = (PrintFn)GetProcAddress(_hinstLib, "Print");
		if (printFn)
		{
			printFn("Plugin Test");
		}
	}
	return 0;
}




