
#ifndef __main_h__
#define __main_h__


#define PIN_LED_INVERT  0
#define PIN_LED        LED_BUILTIN //D13

// Chinese 'Arduino' Micro-Pro does not have LED_BUILTIN and uses inverted logic for RX and TX leds
//#define PIN_LED_INVERT  1
//#define PIN_LED        LED_BUILTIN_RX //D17
//#define PIN_LED        LED_BUILTIN_TX //D30

#define PIN_KEYPAD_R0   8 //4
#define PIN_KEYPAD_R1   A5 //5 //D23
#define PIN_KEYPAD_R2   A4 //6 //D22
#define PIN_KEYPAD_R3   A3 //7 //D21

#define PIN_KEYPAD_C0   7 //0
#define PIN_KEYPAD_C1   6 //1
#define PIN_KEYPAD_C2   5 //2
#define PIN_KEYPAD_C3   4 //3

#define PIN_ENCODER_1A   9 //8
#define PIN_ENCODER_1B   10 //9

#define PIN_ENCODER_2A   11 //18 //A5
#define PIN_ENCODER_2B   12 //19 //A4

#define PIN_ANALOG_1   A0 //A1 //D18
#define PIN_ANALOG_2   A1 //A2 //D19
#define PIN_ANALOG_3   A2 //A3 //D20

//
#define PIN_MISO     PIN_SPI_MISO //12 //D14
#define PIN_MOSI     PIN_SPI_MOSI //11 //D16
#define PIN_SCLK     PIN_SPI_SCK //14 //D15
#define PIN_SS       PIN_SPI_SS //10 //D17

extern float posX;
extern float posY;
extern float posZ;
extern float posA;
extern float posB;
extern float posC;
extern float posU;
extern float posV;
extern float posW;


#endif // __main_h__
