
#ifndef __MyHID_h__
#define __MyHID_h__

#include <stdint.h>
#include <Arduino.h>

#define RAWHID_TX_SIZE  64
#define RAWHID_RX_SIZE  64

class MyHIDCls
{
  public:
    MyHIDCls();
    ~MyHIDCls();

    bool IsModified() const;
    void ForceModified();

    bool Send();
    int Recv();

    bool SetData8(uint8_t idx, uint8_t value, bool check);
    bool SetData16(uint8_t idx, uint16_t value, bool check);
    bool SetData32(uint8_t idx, uint32_t value, bool check);

    bool SetDataFlt(uint8_t idx, float value, bool check);
    bool SetDataDbl(uint8_t idx, double value, bool check);

    
    
  private:  
 
    uint32_t _Time;
    uint8_t _BufferWr[64];
    bool _Modified;


    uint8_t _BufferRd[64];
};


#endif // __MyHID_h__
