
#include "main.h"

#include "TimeUtils.h"

#include "MyHID.h"


MyHIDCls::MyHIDCls() :
  _Time(millis()),
  _BufferWr{0},
  _Modified(false),
  _BufferRd{0}
{

}

MyHIDCls::~MyHIDCls()
{
  
}

bool MyHIDCls::IsModified() const 
{ 
  return _Modified; 
}

void MyHIDCls::ForceModified()
{
  _Modified = true;
}

bool MyHIDCls::Send()
{
  if (_Modified || timeCheck(&_Time, 1000))
  {
    _Time = millis();
    
    *(uint32_t*)(&_BufferWr[60]) = _Time;

    RawHID.send(_BufferWr, 10);
   
    _Modified = false;
    return true;
  }
  return false;
}

int MyHIDCls::Recv()
{
  if (RawHID.recv(_BufferRd, 0) > 0)
  {
    posX = *(float*)&_BufferRd[0];
    posY = *(float*)&_BufferRd[4];
    posZ = *(float*)&_BufferRd[8];
    posA = *(float*)&_BufferRd[12];
    posB = *(float*)&_BufferRd[16];
    posC = *(float*)&_BufferRd[20];
    posU = *(float*)&_BufferRd[24];
    posV = *(float*)&_BufferRd[28];
    posW = *(float*)&_BufferRd[32];
  }
}




bool MyHIDCls::SetData8(uint8_t idx, uint8_t value, bool check)
{
  uint8_t old = _BufferWr[idx];
  _BufferWr[idx] = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetData16(uint8_t idx, uint16_t value, bool check)
{
  uint16_t old = *(uint16_t*)&_BufferWr[idx];
  *(uint16_t*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetData32(uint8_t idx, uint32_t value, bool check)
{
  uint32_t old = *(uint32_t*)&_BufferWr[idx];
  *(uint32_t*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetDataFlt(uint8_t idx, float value, bool check)
{
  float old = *(float*)&_BufferWr[idx];
  *(float*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}
