
#include "Button.h"

ButtonCls::ButtonCls(uint8_t pin) :
  BtnCurrent(false),  
  BtnChange(false),
  _Pin(pin),
  _Time(0)
{

}


bool ButtonCls::Scan() 
{
  pinMode(_Pin, INPUT_PULLUP);

  uint8_t newval = !digitalRead(_Pin); // active low -> invert to high.
  BtnChange = newval && !BtnCurrent;
  BtnCurrent = newval;

  if (BtnChange)
  {
    _Time = millis();
  }


  return BtnChange;
}

uint32_t ButtonCls::GetTime() const
{
  if (!BtnCurrent)
    return 0;
  return millis() - _Time;
}
