
#include <PrintEx.h>
PrintEx serial = Serial;

#include "TimeUtils.h"

#include "Blinky.h"
#include "MyHID.h"

#include "main.h"

//blinking LED
BlinkyCls Blinky(PIN_LED, PIN_LED_INVERT, 100);


//HID
static float posX = 0;
static float posY = 0;
static float posZ = 0;
static float posA = 0;
static float posB = 0;
static float posC = 0;
static float posU = 0;
static float posV = 0;
static float posW = 0;
static bool posNew = false;

static uint16_t blinkyCmd = 0;
static bool blinkyCmdNew = false;
static bool resetCmdNew = false;

static bool rgbAuto = true;
static uint8_t rgbR = 0;
static uint8_t rgbG = 0;
static uint8_t rgbB = 0;
static bool rgbCmdNew = false;


static void _DataCB(uint8_t *data, size_t datalen)
{
  uint8_t cmdId = data[0];

  switch (cmdId)
  {
    case 1:
    {
      posX = *(float*)&data[4];
      posY = *(float*)&data[8];
      posZ = *(float*)&data[12];
      posA = *(float*)&data[16];
      posB = *(float*)&data[20];
      posC = *(float*)&data[24];
      posU = *(float*)&data[28];
      posV = *(float*)&data[32];
      posW = *(float*)&data[36];
      posNew = true;
      break;
    }
    case 2:
    {
      blinkyCmd = *(uint16_t*)&data[1];
      blinkyCmdNew = true;
      break;
    }
    case 3:
    {
      resetCmdNew = true;
      break;
    }
		case 4:
    {
			rgbR = data[1];
			rgbG = data[2];
			rgbB = data[3];
      rgbCmdNew = true;
      break;
    }
  }
}
MyHIDCls MyHID(_DataCB, nullptr);



///////////////
uint8_t sendCmdId = 1;

static uint32_t _update_time;

void setup() 
{
  Serial.begin (115200);
	
  MyHID.SetData8(0, sendCmdId, false);

	pinMode(PIN_LED_R, OUTPUT);
  pinMode(PIN_LED_G, OUTPUT);
  pinMode(PIN_LED_B, OUTPUT);
	
	randomSeed(analogRead(0));	
	_update_time = millis(); 
}

void loop() 
{
  Blinky.Toggle();
	
  if (posNew)
  {
    serial.printf("X%.3f Y%.3f Z%.3f\n", posX, posY, posZ);
    posNew = false;
  }

  if (blinkyCmdNew)
  {
    serial.printf("Blinky: %d\n", blinkyCmd);
    if (blinkyCmd > 10)
      Blinky.SetPeriod(blinkyCmd);
    blinkyCmdNew = false;
  }

  if (resetCmdNew)
  {
    serial.printf("Reset\n");
    Blinky.SetPeriod(100);
		rgbAuto = true;
    resetCmdNew = false;
  }

  if (rgbCmdNew)
	{
		serial.printf("RGB: R%d G%d B%d\n", rgbR, rgbG, rgbB);
		analogWrite(PIN_LED_R, rgbR);
		analogWrite(PIN_LED_G, rgbG);
		analogWrite(PIN_LED_B, rgbB);
		rgbAuto = false;
		rgbCmdNew = false;
	}
	if (timeCheck(&_update_time, 200) && rgbAuto)
	{
		analogWrite(PIN_LED_R, random(255));
		analogWrite(PIN_LED_G, random(255));
		analogWrite(PIN_LED_B, random(255));
	}
	
 
  if (MyHID.Send())
  {
    sendCmdId++;
    if (sendCmdId > 3)
      sendCmdId = 1;
      
    MyHID.SetData8(0, sendCmdId, false);
    
    switch(sendCmdId)
    {
      case 1:
      {
         MyHID.SetDataFlt(48, posX, false);
         MyHID.SetDataFlt(52, posY, false);
         MyHID.SetDataFlt(56, posZ, false);
        break;
      }
      case 2:
      {
         MyHID.SetDataFlt(48, posA, false);
         MyHID.SetDataFlt(52, posB, false);
         MyHID.SetDataFlt(56, posC, false);
        break;
      }
      case 3:
      {
         MyHID.SetDataFlt(48, posU, false);
         MyHID.SetDataFlt(52, posV, false);
         MyHID.SetDataFlt(56, posW, false);
        break;
      }
    }
  }




}
