
#include "SimpleHID.h"

static const uint8_t  _hidReportDesc[] PROGMEM = 
{
//  Collection (7)
    0x06, 0xA0, 0xFF,       // USAGE_PAGE = 0xFFA0 (Vendor Defined Page 1)
    0x09, 0x01,             // USAGE (Vendor Usage 1)
//
    0xA1, 0x01,             // COLLECTION (Application)
   
//  The Input report (13)
    0x09, 0x01,             //   USAGE (Vendor defined)
    0x15, 0x00,             //   LOGICAL_MINIMUM (0)
    0x26, 0x00, 0xFF,       //   LOGICAL_MAXIMUM (255)
    0x75, 0x08,             //   REPORT_SIZE
    0x95, 64,               //   REPORT_COUNT
    0x81, 0x02,             //   INPUT 
     
//  The Output report (13)
    0x09, 0x01,             //   USAGE (Vendor defined)
    0x15, 0x00,             //   LOGICAL_MINIMUM (0)
    0x26, 0x00, 0xFF,       //   LOGICAL_MAXIMUM (255)
    0x75, 0x08,             //   REPORT_SIZE
    0x95, 64,               //   REPORT_COUNT
    0x91, 0x02,             //   OUTPUT 
        
//  End Collection (1)
    0xC0                    // END_COLLECTION
};


SimpleHIDCls::SimpleHIDCls(void) : 
  PluggableUSBModule(1, 1, epType), 
  _Protocol(HID_REPORT_PROTOCOL), 
  _Idle(1),

  _RecvDataCB(nullptr),
  _Data(nullptr),
  _DataLen(0), 
  
  _RecvFeatureCB(nullptr),  
  _Feature(nullptr), 
  _FeatureLen(0)
{
	epType[0] = EP_TYPE_INTERRUPT_IN;
	PluggableUSB().plug(this);
}

int SimpleHIDCls::getInterface(uint8_t* interfaceCount)
{
	*interfaceCount += 1; // uses 1
	HIDDescriptor hidInterface = 
	{
		D_INTERFACE(pluggedInterface, 1, USB_DEVICE_CLASS_HUMAN_INTERFACE, HID_SUBCLASS_NONE, HID_PROTOCOL_NONE),
		D_HIDREPORT(sizeof(_hidReportDesc)),
		D_ENDPOINT(USB_ENDPOINT_IN(pluggedEndpoint), USB_ENDPOINT_TYPE_INTERRUPT, USB_EP_SIZE, 0x01)
	};
	
#ifdef ARDUINO_SAM_DUE
	return USBD_SendControl(0, &hidInterface, sizeof(hidInterface));
#else
	return USB_SendControl(0, &hidInterface, sizeof(hidInterface));
#endif
}

int SimpleHIDCls::getDescriptor(USBSetup& setup)
{
	// Check if this is a HID Class Descriptor request
	if (setup.bmRequestType != REQUEST_DEVICETOHOST_STANDARD_INTERFACE) 
	{ 
	  return 0; 
	}
	if (setup.wValueH != HID_REPORT_DESCRIPTOR_TYPE) 
	{ 
	  return 0; 
	}

	// In a HID Class Descriptor wIndex cointains the interface number
	if (setup.wIndex != pluggedInterface) 
	{ 
	  return 0;
	}

	// Reset the protocol on reenumeration. Normally the host should not assume the state of the protocol due to the USB specs, but Windows and Linux just assumes its in report mode.
	_Protocol = HID_REPORT_PROTOCOL;
#ifdef ARDUINO_SAM_DUE
	return USBD_SendControl(TRANSFER_PGM, _hidReportDesc, sizeof(_hidReportDesc));
#else
	return USB_SendControl(TRANSFER_PGM, _hidReportDesc, sizeof(_hidReportDesc));
#endif
}

bool SimpleHIDCls::setup(USBSetup& setup)
{
	if (pluggedInterface != setup.wIndex) 
	{
		return false;
	}

	uint8_t request = setup.bRequest;
	uint8_t requestType = setup.bmRequestType;

	if (requestType == REQUEST_DEVICETOHOST_CLASS_INTERFACE)
	{
		if (request == HID_GET_REPORT) 
		{
			// TODO: HID_GetReport();
			return true;
		}
		if (request == HID_GET_PROTOCOL) 
		{
			// TODO: Send8(_Protocol);
			return true;
		}
    if (request == HID_GET_IDLE) 
    {
      // TODO: Send8(_Idle);
      return true;
    }
	}

	if (requestType == REQUEST_HOSTTODEVICE_CLASS_INTERFACE)
	{
		if (request == HID_SET_PROTOCOL) 
		{
			_Protocol = setup.wValueL;
			return true;
		}
		if (request == HID_SET_IDLE) 
		{
			_Idle = setup.wValueL;
			return true;
		}
		if (request == HID_SET_REPORT)
		{
			// Check if data has the correct length afterwards
			int len = setup.wLength;

			// Feature (set feature report)
			if(setup.wValueH == HID_REPORT_TYPE_FEATURE)
			{
				if (_Feature && len <= _FeatureLen) 
				{
#ifdef ARDUINO_SAM_DUE
					USBD_RecvControl(_Feature, len);
#else
					USB_RecvControl(_Feature, len);
#endif

          if (_RecvFeatureCB)
            _RecvFeatureCB(_Feature, len);
          
					return true;
				}
			}

			// Output (set out report)
			else if(setup.wValueH == HID_REPORT_TYPE_OUTPUT)
			{
				if (_Data && len <= _DataLen)
				{
#ifdef ARDUINO_SAM_DUE
					USBD_RecvControl(_Data, len);
#else
					USB_RecvControl(_Data, len);
#endif

          if (_RecvDataCB)
            _RecvDataCB(_Data, len);
          
					return true;
				}
			}
		}
	}

	return false;
}
