
#ifndef __MyHID_h__
#define __MyHID_h__

#include <stdint.h>
#include <Arduino.h>

#include "SimpleHID.h"

class MyHIDCls
{
  public:
    MyHIDCls(void (*dataCB)(uint8_t*, size_t), void (*featureCB)(uint8_t*, size_t) = nullptr);
    ~MyHIDCls();

    bool IsModified() const;
    void ForceModified();

    bool Send();

    bool SetData8(uint8_t idx, uint8_t value, bool check);
    bool SetData16(uint8_t idx, uint16_t value, bool check);
    bool SetData32(uint8_t idx, uint32_t value, bool check);

    bool SetDataFlt(uint8_t idx, float value, bool check);
    bool SetDataDbl(uint8_t idx, double value, bool check);

    
    
  private:  
    SimpleHIDCls _HID;
		
    uint32_t _Time;
    uint8_t _BufferWr[64];
    bool _Modified;


    uint8_t _BufferRd[64];
};


#endif // __MyHID_h__
