
#include "TimeUtils.h"

#include "Blinky.h"
#include "Button.h"
#include "Btn4x4.h"
#include "Encoder.h"

#include "MyHID.h"

#include "main.h"

//blinking LED
BlinkyCls Blinky(PIN_LED, PIN_LED_INVERT, 500);

//HID
MyHIDCls MyHID;

//Btn
ButtonCls Btn01(PIN_ANALOG_3);

//Btns
uint32_t btnTime;
const uint8_t brp[4] = {PIN_KEYPAD_R0, PIN_KEYPAD_R1, PIN_KEYPAD_R2, PIN_KEYPAD_R3}; 
const uint8_t bcp[4] = {PIN_KEYPAD_C0, PIN_KEYPAD_C1, PIN_KEYPAD_C2, PIN_KEYPAD_C3}; 
Btn4x4Cls Btns(brp, bcp);


//Encoder
uint32_t encTime;
EncoderCls Enc01(PIN_ENCODER_1A, PIN_ENCODER_1B);
EncoderCls Enc02(PIN_ENCODER_2A, PIN_ENCODER_2B);


float posX = 0;
float posY = 0;
float posZ = 0;
float posA = 0;
float posB = 0;
float posC = 0;
float posU = 0;
float posV = 0;
float posW = 0;

void setup() 
{
  //Btns
  btnTime = millis();

  //Encoders
  encTime = millis();
  
}

void loop() 
{
  Blinky.Toggle();


  if (timeCheck(&encTime, 1))
  {
    Enc01.Scan();
    Enc02.Scan();
  }

  if (timeCheck(&btnTime, 50))
  {
    if (Btns.Scan())
      MyHID.ForceModified();

    if (Btn01.Scan())
      MyHID.ForceModified();

    if ((Enc01.Delta != 0) || (Enc02.Delta != 0))
      MyHID.ForceModified();

    MyHID.SetData16(0, Btns.BtnCurrent, false);
    MyHID.SetData16(2, Btns.BtnChange, false);

    MyHID.SetData16(4, analogRead(PIN_ANALOG_1), true);
    MyHID.SetData16(6, analogRead(PIN_ANALOG_2), true);
    //MyHID.SetData16(8, analogRead(PIN_ANALOG_3), true);

    MyHID.SetData8(10, Btn01.BtnCurrent, false);
    MyHID.SetData8(11, Btn01.BtnChange, false);
    MyHID.SetData16(12, (uint16_t)Btn01.GetTime(), false);

    MyHID.SetData8(14, 0, false);
    MyHID.SetData8(15, 0, false);
    MyHID.SetData16(16, 0, false);

    MyHID.SetData16(18, Enc01.Delta, false); 
    MyHID.SetData16(20, Enc01.Value, false);
    MyHID.SetData16(22, Enc02.Delta, false); 
    MyHID.SetData16(24, Enc02.Value, false);

    //test loopback
    MyHID.SetDataFlt(48, posX, false);
    MyHID.SetDataFlt(52, posY, false);
    MyHID.SetDataFlt(56, posZ, false);
  } 

  
  if (MyHID.Send())
  {
    MyHID.SetData16(2, 0, false); // Clear btns change
    MyHID.SetData8(11, 0, false); // Clear btn01 change
    MyHID.SetData8(15, 0, false); // Clear btn02 change

    Enc01.Delta = 0;
    Enc02.Delta = 0;
  }

  
     
  
  

}
