
#ifndef __SimpleHID_h__
#define __SimpleHID_h__

#include <stdint.h>
#include <Arduino.h>
#include <HID.h>


typedef void (*USBRecvCallback)(uint8_t *data, size_t datalen);


class SimpleHIDCls : public PluggableUSBModule
{
public:
	SimpleHIDCls(void);

  void SetRecvDataCB(USBRecvCallback cb, uint8_t* data, size_t datalen)
  {
    _Data = (uint8_t*)data;
    _DataLen = datalen;
    _RecvDataCB = cb;
  }
  
  void SetRecvFeatureCB(USBRecvCallback cb, uint8_t* feat, size_t featlen)
  {
    _Feature = (uint8_t*)feat;
    _FeatureLen = featlen;
    _RecvFeatureCB = cb;
  }

  size_t USBSend(uint8_t *data, size_t datalen)
  {
    return USB_Send(pluggedEndpoint | TRANSFER_RELEASE, data, datalen);
  }

protected:
  //PluggableUSBModule
  virtual int getInterface(uint8_t* interfaceCount) override;
  virtual int getDescriptor(USBSetup& setup) override;
  virtual bool setup(USBSetup& setup) override;

  //
  uint8_t epType[1]; // platform dependant!!! 
  //uint32_t epType[1]; // platform dependant!!!
    
  uint8_t _Protocol;
  uint8_t _Idle;


  USBRecvCallback _RecvDataCB;
  uint8_t* _Data;
	uint16_t _DataLen;

  USBRecvCallback _RecvFeatureCB;
	uint8_t* _Feature;
	int _FeatureLen;
};


#endif
