
#include "main.h"

#include "TimeUtils.h"

#include "MyHID.h"



static void _DataCB(uint8_t *data, size_t datalen)
{
    posX = *(float*)&data[0];
    posY = *(float*)&data[4];
    posZ = *(float*)&data[8];
    posA = *(float*)&data[12];
    posB = *(float*)&data[16];
    posC = *(float*)&data[20];
    posU = *(float*)&data[24];
    posV = *(float*)&data[28];
    posW = *(float*)&data[32];
}

static void _FeatureCB(uint8_t *data, size_t datalen)
{
  
}


MyHIDCls::MyHIDCls() :
  _Time(millis()),
  _BufferWr{0},
  _Modified(false),

  _BufferRd{0}
{
  _HID.SetRecvDataCB(_DataCB, _BufferRd, sizeof(_BufferRd));
  //_HID.SetRecvFeatureCB(_FeatureCB, NULL, 0);
}

MyHIDCls::~MyHIDCls()
{
  
}

bool MyHIDCls::IsModified() const 
{ 
  return _Modified; 
}

void MyHIDCls::ForceModified()
{
  _Modified = true;
}

bool MyHIDCls::Send()
{
  if (_Modified || timeCheck(&_Time, 1000))
  {
    _Time = millis();
    
    *(uint32_t*)(&_BufferWr[60]) = _Time;

    _HID.USBSend(_BufferWr, sizeof(_BufferWr));
   
    _Modified = false;
    return true;
  }
  return false;
}

bool MyHIDCls::SetData8(uint8_t idx, uint8_t value, bool check)
{
  uint8_t old = _BufferWr[idx];
  _BufferWr[idx] = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetData16(uint8_t idx, uint16_t value, bool check)
{
  uint16_t old = *(uint16_t*)&_BufferWr[idx];
  *(uint16_t*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetData32(uint8_t idx, uint32_t value, bool check)
{
  uint32_t old = *(uint32_t*)&_BufferWr[idx];
  *(uint32_t*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}

bool MyHIDCls::SetDataFlt(uint8_t idx, float value, bool check)
{
  float old = *(float*)&_BufferWr[idx];
  *(float*)(&_BufferWr[idx]) = value;
  bool result = old != value;
  if (check) 
    _Modified |= result;
  return result;
}
