
#include "Btn4x4.h"

Btn4x4Cls::Btn4x4Cls(const uint8_t *row, const uint8_t *col) :
  BtnCurrent(0), 
  BtnChange(0),
  _RowPins(row),
  _ColPins(col)
{

}


bool Btn4x4Cls::Scan() 
{
	bool result = false;
  
	// Intialize the row pins. Allows sharing these pins with other hardware.
	for (uint8_t r=0; r<_Cnt; r++)
		pinMode(_RowPins[r], INPUT_PULLUP);

	for (uint8_t c=0; c<_Cnt; c++) 
	{
		pinMode(_ColPins[c], OUTPUT);
		digitalWrite(_ColPins[c], LOW);	// Begin column pulse output.
   
		for (uint8_t r=0; r<_Cnt; r++) 
		{
      uint8_t i = c*_Cnt + r;
      uint8_t newval = !digitalRead(_RowPins[r]); // active low -> invert to high.
      uint8_t oldval = bitRead(BtnCurrent, i);
			bitWrite(BtnCurrent, i, newval);  
      bitWrite(BtnChange, i, newval & !oldval); 
      result |= newval && !oldval;
		}
   
		// Set pin to high impedance input and end column pulse.
		digitalWrite(_ColPins[c], HIGH);
		pinMode(_ColPins[c], INPUT);
	}

  return result;
}
