
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/*
show				Shows main window
hide				Hides main window
exit				Exits program
estop				Toggles EStop
start				Performs Start
stop				Performs Stop
pause				Performs Pause
isestop				Returns 1 if EStop is active, 0 otherwise
ispause				Returns 1 if Pause is active, 0 otherwise
open "filename"		Opens GCode from file
gcode "program"		Opens GCode from string
close				Closes opened GCode
mdi "command"		Executes MDI command
param name=value	Sets parameter value
param name			Returns parameter value
posabs				Returns absolute position for all axes
posabsx				Returns absolute position for X axis
posabsy				Returns absolute position for Y axis
posabsz				Returns absolute position for Z axis
posabsa				Returns absolute position for A axis
posabsb				Returns absolute position for B axis
posabsc				Returns absolute position for C axis
posabsu				Returns absolute position for U axis
posabsv				Returns absolute position for V axis
posabsw				Returns absolute position for W axis
pos					Returns position for all axes
posx				Returns position for X axis
posy				Returns position for Y axis
posz				Returns position for Z axis
posa				Returns position for A axis
posb				Returns position for B axis
posc				Returns position for C axis
posu				Returns position for U axis
posv				Returns position for V axis
posw				Returns position for W axis
speed				Returns current speed
accel				Returns current acceleration
spindle				Returns current spindle RPM
input				Returns value of INPUT 
input1				Returns value of INPUT 1 pin
input2				Returns value of INPUT 2 pin
input3				Returns value of INPUT 3 pin
input4				Returns value of INPUT 4 pin
input5				Returns value of INPUT 5 pin
input6				Returns value of INPUT 6 pin
input7				Returns value of INPUT 7 pin
input8				Returns value of INPUT 8 pin
jog					Returns value of JOG
jog1				Returns value of JOG 1 pin
jog2				Returns value of JOG 2 pin
jog3				Returns value of JOG 3 pin
jog4				Returns value of JOG 4 pin
jog5				Returns value of JOG 5 pin
jog6				Returns value of JOG 6 pin
jog7				Returns value of JOG 7 pin
jog8				Returns value of JOG 8 pin
joga1				Returns value of JOG A1 pin
joga2				Returns value of JOG A2 pin
jogs				Returns value of JOG S pin
jogpot				Returns value of JOG POT
limit				Returns value of LIMIT
limit1				Returns value of LIMIT 1 pin
limit2				Returns value of LIMIT 2 pin
limit3				Returns value of LIMIT 3 pin
limit4				Returns value of LIMIT 4 pin
limit5				Returns value of LIMIT 5 pin
limit6				Returns value of LIMIT 6 pin
limit7				Returns value of LIMIT 7 pin
limit8				Returns value of LIMIT 8 pin
limit9				Returns value of LIMIT 9 pin
output				Returns value of OUTPUT
output1				Returns value of OUTPUT 1 pin
output2				Returns value of OUTPUT 2 pin
output3				Returns value of OUTPUT 3 pin
output4				Returns value of OUTPUT 4 pin
output5				Returns value of OUTPUT 5 pin
output6				Returns value of OUTPUT 6 pin
output7				Returns value of OUTPUT 7 pin
output8				Returns value of OUTPUT 8 pin
aux1				Returns value of AUX 1 pin
aux2				Returns value of AUX 2 pin
aux3				Returns value of AUX 3 pin
aux4				Returns value of AUX 4 pin
buffer				Returns amount of free buffer	
bufferpercent		Returns percent of buffer utilization
linecount			Returns number of lines in GCode program
line				Returns line number currently executing
*/




#define PIPENAME	TEXT("\\\\.\\pipe\\PlanetCNC")

HANDLE hPipe = INVALID_HANDLE_VALUE;

struct OverlappedEvent
{
	OverlappedEvent()
	{
		memset(&over, 0, sizeof(over));
		over.hEvent = CreateEvent(0, TRUE, FALSE, 0);
	}

	~OverlappedEvent()
	{
		CloseHandle(over.hEvent);
	}
	OVERLAPPED over;
};


bool open()
{
	if (hPipe != INVALID_HANDLE_VALUE)
		return true;

	hPipe = CreateFile(PIPENAME, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (hPipe != INVALID_HANDLE_VALUE)
		return true;

	return false;
}

void close()
{
	if (hPipe != INVALID_HANDLE_VALUE)
	{
		CloseHandle(hPipe);
		hPipe = INVALID_HANDLE_VALUE;
	}
}


bool waitForIO(OverlappedEvent& over, int timeOutMilliseconds)
{
	HANDLE handles[] = { over.over.hEvent };
	DWORD waitResult = WaitForMultipleObjects(1, handles, FALSE, timeOutMilliseconds >= 0 ? timeOutMilliseconds : INFINITE);

	if (waitResult == WAIT_OBJECT_0)
		return true;

	CancelIo(hPipe);
	return false;
}

int read(void* destBuffer, const int maxBytesToRead, const int timeOutMilliseconds)
{
	if (open())
	{
		if (maxBytesToRead <= 0)
			return 0;

		OverlappedEvent over;
		unsigned long numRead;

		if (ReadFile(hPipe, destBuffer, (DWORD)maxBytesToRead, &numRead, &over.over))
			return (int)numRead;

		const DWORD lastError = GetLastError();

		if (lastError == ERROR_IO_PENDING)
		{
			if (!waitForIO(over, timeOutMilliseconds))
				return -1;

			if (GetOverlappedResult(hPipe, &over.over, &numRead, FALSE))
				return (int)numRead;
		}
	}
	return -1;
}

int write(const void* sourceBuffer, int numBytesToWrite, int timeOutMilliseconds)
{
	if (open())
	{
		if (numBytesToWrite <= 0)
			return 0;

		OverlappedEvent over;
		unsigned long numWritten;

		if (WriteFile(hPipe, sourceBuffer, (DWORD)numBytesToWrite, &numWritten, &over.over))
			return (int)numWritten;

		if (GetLastError() == ERROR_IO_PENDING)
		{
			if (!waitForIO(over, timeOutMilliseconds))
				return -1;

			if (GetOverlappedResult(hPipe, &over.over, &numWritten, FALSE))
				return (int)numWritten;
		}
	}
	return -1;
}



int main(int argc, char* argv[])
{
	char msg[1024];
	int msglen, lenwr, lenrd;

	do
	{
		printf("PlanetCNC: ");
		fgets(msg, 1024, stdin);
		msglen = strnlen(msg, 1024);

		if (msglen > 1)
		{
			read(msg, 1024, 1); // clear previous return value

			lenwr = write(msg, msglen, 100);
			if (lenwr > 0)
			{
				lenrd = read(msg, 1024, 100);
				if (lenrd > 0)
				{
					msg[lenrd] = 0;
					printf("%s\n", msg);
				}
			}
		}

	} while (msglen > 1);

	close();

	return 0;
}

